<?php  defined('BASEPATH') OR exit('No direct script access allowed');

class Login extends CI_Controller {

        public function __construct()
        {
                parent::__construct();
                
                $this->load->helper('cookie');
                if($this->input->cookie('remember_user',TRUE))
                {    
                    $this->input->cookie('remember_user',TRUE);
                }
                $this->load->model('user');
        }
    
	public function index()
	{
            $this->load->library('form_validation');
            if($this->input->post('submit') !='')
            {
                
                $this->form_validation->set_rules('email', 'Email', 'valid_email|required');
                $this->form_validation->set_rules('password', 'Password', 'required');
                if ($this->form_validation->run() != FALSE)
                {
                    $email = $this->input->post('email');
                    $password = $this->input->post('password');
                    $this->load->model('user_model','user');
                    $result = $this->user->validate($email, $password);
                    
                    if($result)
                    {
                        $userData  = array(
                                        'is_logged_in'=>true,
                                        'user_role'=>$result->user_type,
                                        'user_data'=>$result
                                    );
                        $this->session->set_userdata($userData);
                        if($result->user_type == 1)
                        {
                            redirect('patient');
                        }
                        elseif($result->user_type == 2 || $result->user_type == 3)
                        {
                            redirect('doctor');
                        }
                    }
                    else
                    {
                        $errorMessage['error'] = array('message_type' =>'Error','message' => 'Invalid credentials.');
                        $this->session->set_userdata($errorMessage);
                    }
                    
                }
            }
            $this->load->view('login');
	}
	
	public function fogetPassword()
        {
            
            if ($this->input->post('email')) 
            {
                $this->form_validation->set_rules('email', 'Email', 'trim|required|valid_email');

                $error = array();

                if ($this->form_validation->run() === False) {
                    $error = $this->form_validation->error_array();
                    echo $error;die;
                }

                $email = $this->input->post('email');
                
                $userExist = $this->user->userExist($email);
                if ($userExist) 
                {
                    $this->load->helper('password');
                    $password = generatePassword();
                    $this->load->library('elasticMail');
                    $mail = new ElasticMail();
                    $response = $mail->SendEmail($email, "New Password", "help@chawtechsolutions.in", "MyMd", "Your new password is " . $password);
                    $result = 0;

                    if ($response) {
                        $result = $this->user->resetPassword($userExist, $password);
                    }

                    if ($result)
                    {
                        echo "New  password sent to your email.";
                    } 
                    else 
                    {
                        echo "Some error happen please try again later.";
                    }
                } 
                else
                {
                    echo "This mail id is not registerd.";
                }
            } 
            else
            {
                echo "Please enter a valid email id.";
            }
           
        }
        
	
        
        
}
