<?php  defined('BASEPATH') OR exit('No direct script access allowed');

class Login extends CI_Controller {

        public function __construct()
        {
                parent::__construct();
                
                $this->load->helper('cookie');
                if($this->input->cookie('remember_user',TRUE))
                {    
                    $this->input->cookie('remember_user',TRUE);
                }
        }
    
	public function index()
	{
            $this->load->library('form_validation');
			$this->load->library('session');
            if($this->input->post('submit') !='')
            {
                
                $this->form_validation->set_rules('email', 'Email', 'valid_email|required');
                $this->form_validation->set_rules('password', 'Password', 'required');
                if ($this->form_validation->run() != FALSE)
                {
                    $email = $this->input->post('email');
                    $password = $this->input->post('password');
                    $this->load->model('user_model','user');
                    $result = $this->user->validate($email, $password);
                    
                    if($result)
                    {
                        $errorMessage['success'] = array('message_type' =>'Success','message' => 'Login Successful.');
                        $this->session->set_userdata($errorMessage);
                        $userData  = array(
							'is_logged_in'=>true,
							'user_role'=>$result->UserRole,
							'user_data'=>$result
						);
                        $this->session->set_userdata($userData);
						//print_r($this->session->userdata());
						
                        redirect('admin');
                    }
                    else
                    {
                        $errorMessage['error'] = array('message_type' =>'Error','message' => 'Invalid credentials.');
                        $this->session->set_userdata($errorMessage);
                    }
                    
                }
            }
            $this->load->view('login_admin');
	}
	
	public function fogetPassword($page = 'login')
        {
			$email = $this->input->post('email');
			
            $form_data = array('username' => $email);
            $this->load->model('user_model');
            //$userData  = $this->user_model->getUser($form_data);
            
			$userExist = $this->user_model->userExist($email);
			
			if($userExist) 
			{
				$this->load->helper('password');
				$password 	= generatePassword();
                               
				$this->load->library('elasticMail');
				$mail = new ElasticMail();
				$mailResponse = $mail->SendEmail($email, "New Password", "raghavendra@chawtechsolutions.com", "MyMd", "Your new password is " . $password);
				
				$mailResponse= json_decode($mailResponse);
					
				$result = 0;

				if($mailResponse && $mailResponse->success===true)
				{
					$result = $this->user_model->resetPassword($userExist, $password);
				}

				if($result)
				{
					echo "Mail has been sent on your email id.";
				} 
				else 
				{
					echo "Some error happen please try again later.";
				}
			} 
			else
			{
				echo "This mail id is not registerd.";
			}
				
            /* $errorMessage = array();
                
            if(!$userData)
            {
                $errorMessage = array(
                    'message_type'=>'error',
                    'message'=>'User Name Not Found!!!',
                    'color'=>'#F78C8C'
                );
                
            }
            else 
            {   
				$this->load->helper('password');
                $password 	= generatePassword();
                $username	= $userData['username'];
                $email		= $userData['email'];

                $subject = 'Password Recovery';

              
                 $message = "<table width='600'>
                        <tr>
                          <td colspan=2><center><B>Account Detail</B></center></td>
                        </tr>
                        <tr>
                          <td><B>User Name</B> </td><td>: ".$username."</td>
                        </tr>
                        <tr>
                          <td><B>Password</B> </td><td>: ".$password."</td>
                        </tr>
                    </table>			
                ";
                // To send HTML mail, the Content-type header must be set
                $headers  = 'MIME-Version: 1.0' . "\r\n";
                $headers .= 'Content-type: text/html; charset=iso-8859-1' . "\r\n";

                // Additional headers
                $headers .= 'From: info@chawtechsolutions.ch' . "\r\n";
                $to = $email;
                
                

                // Mail it
                $mail = mail($to, $subject, $message, $headers);
                
                if(!$mail)
                {
                    $errorMessage = array(
                        'message_type'=>'Error',
                        'message'=>'Mail has been not sent on your email id.',
                        'color'=>'#F78C8C'
                    );
                    
                }
                else 
                {
                    $errorMessage = array(
                        'message_type'=>'Success',
                        'message'=>'Mail has been sent on your email id.',
                        'color'=>'#E8F4D2'
                    );
                }
            }
            
            $this->session->set_userdata($errorMessage); */
                
            //redirect('admin');
           
        }
        
	public function validate_login()
	{
            $form_data = array(
                'username' => $this->input->post('UserName'),
                'password' => $this->input->post('Password')
            );
            $this->load->model('user');
            $userData  = $this->user->getUser($form_data);
            
            
            if($userData != false)
            {
                $remember = $this->input->post('remember');
                
                if($remember == 'remember')
                {
                    $this->input->set_cookie('remember_user',$this->input->post('UserName'), 3600);
                    $this->input->set_cookie('remember_password',$this->input->post('Password'), 3600);
                    
                }
                
                $data = array(
                    'is_logged_in'=>true,
					'user_data'=>$userData,
					'user_role'=>$userData['role']
					);
                
                $this->session->set_userdata($data);
				//die;		
				switch($userData['role'])
				{
					case 'admin':
						redirect('admin');
						exit;
					
					default :
						redirect('login');
				}
				
            }
            else
            {
                $page="login";
                $data['title'] = ucfirst($page); // Capitalize the first letter
                
                $errorMessage = array(
                    'message_type'=>'error',
                    'message'=>'Invalid Login Credentials!!!<br/>Please Enter Valid Credentials.',
                    'color'=>'#F78C8C'
                );
                $this->session->set_userdata($errorMessage);
                redirect('login');
            }
	}
}
