<?php

defined('BASEPATH') OR exit('No direct script access allowed');


require APPPATH . '/libraries/REST_Controller.php';

class Doctor extends REST_Controller {

    public function __construct()
    {
        parent::__construct();
        $this->load->model('doctor_model','doctor');
        $this->load->library('form_validation');
    }

    public function verify_npi_get()
    {
        $npi_number = $this->get('npi_number');
       
        $res2 = new blankClass();
        if(isset($npi_number))
        {
            $result = $this->checkNPI($npi_number);
            //$this->response($result, REST_Controller::HTTP_OK);
            if(isset($result->results))
            {
                if($result->result_count == 1)
                {
                    if($result->results[0]->enumeration_type == 'NPI-1')
                    {
                        $res = $result->results[0];
                        $npiDetail = array(
                                    'npi_number'=>$res->number,
                                    'first_name'=>$res->basic->first_name,
                                    'last_name'=>$res->basic->last_name,
                                    //'middle_name'=>$res->basic->middle_name,
                                    'credential'=>$res->basic->credential,
                                    'taxonomy'=>$res->taxonomies[0]->code,
                                    'gender_code'=>$res->basic->gender,
                                    'mailing_address1'=>$res && $res->addresses[1]->address_1?$res->addresses[1]->address_1:'',
                                    'mailing_address2'=>$res && $res->addresses[1]->address_2?$res->addresses[1]->address_2:'',
                                    'mailing_city'=>$res->addresses[1]->city,
                                    'mailing_state'=>$res->addresses[1]->state,
                                    'mailing_country_code'=>$res->addresses[1]->country_code,
                                    'mailing_postal_code'=>$res->addresses[1]->postal_code,
                                    'mailing_phone'=>isset($res->addresses[1]->telephone_number)?$res->addresses[1]->telephone_number:'',
                                    'practice_address1'=>$res->addresses[0]->address_1,
                                    'practice_address2'=>isset($res->addresses[0]->address_2) && $res->addresses[0]->address_2!=''?$res->addresses[0]->address_2:'',
                                    'practice_city'=>$res->addresses[0]->city,
                                    'practice_state'=>$res->addresses[0]->state,
                                    'practice_country_code'=>$res->addresses[0]->country_code,
                                    'practice_postal_code'=>$res->addresses[0]->postal_code,
                                    'practice_phone'=>$res->addresses[0]->telephone_number,
                                    //'practice_fax'=>$res->addresses[0]->fax_number,
                                    
                                    
                                );
                        $this->response(["data"=>$npiDetail], REST_Controller::HTTP_OK);
                    }
                    else
                    {
                        $return['success'] 		= false;
                        $return['message'] 		= "NPI number not avaiable";
                        $return['error'] 		= '';
                        $return['data'] 		= '';
                        $this->response($return, 302);
                    }
                }
                else
                {
                    $return['success'] 		= false;
                    $return['message'] 		= "NPI number not avaiable";
                    $return['error'] 		= '';
                    $return['data'] 		= '';
                    $this->response($return, 301);
                }
            }
            else
            {
                $return['success'] 		= false;
                $return['message'] 		= "SOmething went wrong";
                $return['error'] 		= '';
                $return['data'] 		= '';
                $this->response($return, REST_Controller::HTTP_SEE_OTHER);
            }
        }
    }
    
    public function npi2_put()
    {
        $data = json_decode( file_get_contents('php://input'),true);
        
        $res = new blankClass();
        if(isset($data['id']) && isset($data['npi_number']))
        {
            $result = $this->checkNPI($data['npi_number']);
           
            if($result)
            {
                if($result->result_count == 1)
                {
                    if($result->results[0]->enumeration_type == 'NPI-1')
                    {
                        $id = $data['id'];
                        $taxonomy = $data['taxonomy'];
                        unset($data['id']);
                        unset($data['taxonomy']);
                        $data['npi_verification'] = 1;
                        $this->doctor->updateProfile($id,$data);
                        $this->response($res, REST_Controller::HTTP_OK);
                    }
                    else
                    {
                        $this->response($res, 302);
                    }
                }
                else
                {
                    $this->response($res, 301);
                }
            }
            else
            {
                $this->response($res, 303);
            }
        }
    }
    
    public function npi_put()
    {
        $data = json_decode( file_get_contents('php://input'),true);
        
        $res = new blankClass();
        if(isset($data['id']) && isset($data['npi_number']))
        {
            $result = $this->checkNPI($data['npi_number']);
             
            if($result)
            {
                if($result->result_count == 1)
                {
                    if($result->results[0]->enumeration_type == 'NPI-1')
                    {
                        $id = $data['id'];
                        $this->doctor->updateNPI($id,$result->results[0]);
                        $dt = array();
                        $dt['npi_verification'] = 1;
                        $this->doctor->updateProfile($id,$data);
                        $return['success'] 		= true;
                        $return['message'] 		= "npi updated successfully.";
                        $return['error'] 		= '';
                        $return['data'] 		= '';
                        $this->response($return, REST_Controller::HTTP_OK);
                    }
                    else
                    {
                        $this->response($res, 302);
                    }
                }
                else
                {
                    $this->response($res, 301);
                }
            }
            else
            {
                $this->response($res, 303);
            }
        }
    }
    
    private function checkNPI($npi_number)
    {
        $url = "https://npiregistry.cms.hhs.gov/api/?number=".$npi_number.'&version=2.1';
        $result = file_get_contents($url);
        $data = json_decode($result);
        return $data;
    }
    
    public function index_put()
    {
        $id = $this->get('id');
        $id = str_replace('_', '-', $id);
        $data = json_decode( file_get_contents('php://input'),true);
        
        if($id)
        {	
            if($this->doctor->updateProfile($id,$data))
            {
                $this->response('', REST_Controller::HTTP_OK);
            }
            else
            {
                $return['success'] 		= false;
                $return['message'] 		= "Profile not updated.";
                $return['error'] 		= '';
                $return['data'] 		= '';
                $this->response($return, REST_Controller::HTTP_NOT_MODIFIED);
            }
        }
        else 
        {
            $return['success'] 		= false;
            $return['message'] 		= "User not exist.";
            $return['error'] 		= '';
            $return['data'] 		= '';
            $this->response($return, REST_Controller::HTTP_BAD_REQUEST); 
        }
    }
    
    public function index_get()
    {
        $id = $this->get('id');
        $id = str_replace('_', '-', $id);
        
        if($id === NULL)
        {
            $return['success'] 		= false;
            $return['message'] 		= "User not exist.";
            $return['error'] 		= '';
            $return['data'] 		= '';
            $this->response($return, REST_Controller::HTTP_BAD_REQUEST); 
        }
        else
        {
            $result = $this->doctor->getDoctor($id);
            
            if(empty($result))
            {
                
                $this->response(["data"=>$result], REST_Controller::HTTP_NO_CONTENT);
            }
            else
            {
                $this->response(["data"=>$result], REST_Controller::HTTP_OK);
            }
            
        }
    }
    
    public function consults_get()
    {
        $id = $this->get('id');
        $id = str_replace('_', '-', $id);
        if($id === NULL)
        {
            $this->response(NULL, REST_Controller::HTTP_BAD_REQUEST); 
        }
        else
        {
            $result = array('active_consult'=>array(),'inactive_consult'=>array());
            
            $result['new_consult'] = $this->doctor->getNewConsult($id);
            $result['active_consult'] = $this->doctor->getActiveConsult($id);
            $result['inactive_consult'] = $this->doctor->getInActiveConsult($id); 
            
            if(empty($result))
            {
                
                $this->response(["data"=>[]], REST_Controller::HTTP_NO_CONTENT);
            }
            else
            {
                $this->response(["data"=>$result], REST_Controller::HTTP_OK);
            }
            
        }
             
    }
    
    public function consultQuestion_get()
    {
        $id = $this->get('id');
        if($id === NULL)
        {
            $this->response(NULL, REST_Controller::HTTP_BAD_REQUEST); 
        }
        else
        {
            $result = $this->doctor->getConsultQuestion($id);
            if(empty($result))
            {
                
                $this->response(["data"=>$result], REST_Controller::HTTP_NO_CONTENT);
            }
            else
            {
                $this->response(["data"=>$result], REST_Controller::HTTP_OK);
            }
            
        }
    }
    
    public function answer_post()
    {
        $data = json_decode( file_get_contents('php://input'),true);
        //print_r($data);die;
        $res = new blankClass();
        if(isset($data['consult_id']) && isset($data['doctor_id']) && isset($data['question_id']) && isset($data['answer']))
        {     
            $consultActive = $this->doctor->checkConsultActive($data['consult_id'],$data['doctor_id']);
            if($consultActive)
            {
                $currentDateTime = date("Y-m-d H:i:s");
                    
                if($consultActive->doctor_id == NULL)
                {
                    $tmpdate = new DateTime();
                    $settings = $this->session->userdata('Settings');
                    $tmpdate->add(new DateInterval("PT".$settings->Consultation_session_usage_time."H"));
                    $end_date =  $tmpdate->format('Y-m-d H:i:s');
                    $dataConsult = array(
                        "end_date"=>$end_date,
                        "doctor_id"=>$data['doctor_id']
                    );
                    $this->doctor->updateConsultDoctor($data['consult_id'],$dataConsult);
                }
                $dataAnswer = array(
                    "answer"=>$data['answer'],
                    "answered_on_date"=>$currentDateTime
                );
                if($this->doctor->save_answer($data['question_id'],$dataAnswer))
                {
                    $return['success'] 		= true;
                    $return['message'] 		= "Answer added successfully.";
                    $return['error'] 		= '';
                    $return['data'] 		= '';
                    $this->response($return, REST_Controller::HTTP_OK);
                }
            }
            else
            {
                $return['success'] 		= false;
                $return['message'] 		= "Consult is not active";
                $return['error'] 		= '';
                $return['data'] 		= '';
                $this->response($return, REST_Controller::HTTP_NOT_IMPLEMENTED); 
            }
        }
        else
        {
            $return['success'] 		= false;
            $return['message'] 		= "Some thing went wrong";
            $return['error'] 		= '';
            $return['data'] 		= '';
            $this->response($return, REST_Controller::HTTP_BAD_REQUEST); 
        }
    }
    
    public function password_put()
    {
        $id = $this->get('id');
        $data = json_decode( file_get_contents('php://input'),true);
        $res = new blankClass();
        
        if($id && isset($data['password']) && isset($data['oldpassword']))
        {
            $_POST = $data;
            
            $resMatch = $this->doctor->matchPassword($id,md5($data['oldpassword']));
            if($resMatch)
            {
                unset($data['oldpassword']);
                $data['password'] = md5($data['password']);
                if($this->doctor->updateDoctor($resMatch,$data))
                {
                    $return['success'] 		= true;
                    $return['message'] 		= "Password changed successfully.";
                    $return['error'] 		= '';
                    $return['data'] 		= '';
                    $this->response($return, REST_Controller::HTTP_OK);
                }
                else
                {
                    $return['success'] 		= false;
                    $return['message'] 		= "Password not modified";
                    $return['error'] 		= '';
                    $return['data'] 		= '';
                    $this->response($return, REST_Controller::HTTP_NOT_MODIFIED);
                }
            }
            else
            {
                $return['success'] 		= false;
                $return['message'] 		= "Old password not matched";
                $return['error'] 		= '';
                $return['data'] 		= '';
                $this->response($return, REST_Controller::HTTP_UNAUTHORIZED);
            }
            
        }
        else 
        {
            $return['success'] 		= false;
            $return['message'] 		= "Some thing went wrong";
            $return['error'] 		= '';
            $return['data'] 		= '';
            $this->response($return, REST_Controller::HTTP_BAD_REQUEST); 
        }
    }
    
    public function logout_get()
    {
        $DriverID = $this->get('DriverID');
        
        if($DriverID === NULL)
        {
            $this->response(NULL, REST_Controller::HTTP_BAD_REQUEST); 
        }
        else
        {
            $this->db->where('DriverID',$DriverID);
                
            $result = $this->db->update('tbldoctor',array('LoggedIn'=>0));
            
            if($result)
            {
               $this->response([], REST_Controller::HTTP_OK);
            }
            else
            {
                $this->response(NULL, REST_Controller::HTTP_BAD_REQUEST); 
            }
            
        }
    }
    
    public function location_put()
    {
        $DriverID = $this->get('DriverID');
        $data = json_decode( file_get_contents('php://input'),true);
        $res = new blankClass();
        if($DriverID && isset($data['LocGPSLongitude']) && isset($data['LocGPSLatitude']))
        {
			$_POST 		= $data;
			
			$this->form_validation->set_rules('LocGPSLongitude', 'LocGPSLongitude', 'required');
			$this->form_validation->set_rules('LocGPSLatitude', 'LocGPSLatitude', 'required');			
			
			$error 	= array();
			
			if($this->form_validation->run() === false)
			{
				$error = $this->form_validation->error_array();
				$this->response(["error" => $error], REST_Controller::HTTP_BAD_REQUEST);
			}
			
            if($this->doctor->updateDriver($DriverID,$data))
            {
                $this->response($res, REST_Controller::HTTP_OK);
            }
            else
            {
                $this->response($res, REST_Controller::HTTP_NOT_MODIFIED);
            }
            
        }
        else 
        {
            $this->response($res, REST_Controller::HTTP_BAD_REQUEST); 
        }
    }
    
    public function fcm_put()
    {
        $id = $this->get('id');
        $id = str_replace('_', '-', $id);
        $data = json_decode( file_get_contents('php://input'),true);
        if($id && isset($data['fcm_key']))
        {
			
            if($this->doctor->updateDoctorFCM($id,$data))
            {
                $this->response('', REST_Controller::HTTP_OK);
            }
            else
            {
                $this->response('', REST_Controller::HTTP_NOT_MODIFIED);
            }
            
        }
        else 
        {
            $this->response(NULL, REST_Controller::HTTP_BAD_REQUEST); 
        }
    }
    
    public function state_get()
    {        
        $res = new blankClass();
        
            $query = $this->db->get('state');
            $result = $query->result();
            
            if($result)
            {
                $this->response(["data"=>$result], REST_Controller::HTTP_OK);
            }
            else
            {
                $this->response($res, REST_Controller::HTTP_UNAUTHORIZED);
            }
            
        
    }
    
    public function taxonomylist_get()
    {        
        $res = new blankClass();
        $this->db->select("`id` as taxonomy_id, `code`, `name`");
        $this->db->order_by("name");
            $query = $this->db->get('taxonomy');
            $result = $query->result();
            
            if($result)
            {
                $this->response(["data"=>$result], REST_Controller::HTTP_OK);
            }
            else
            {
                $this->response($res, REST_Controller::HTTP_UNAUTHORIZED);
            }
            
        
    }
    
    public function taxonomyadd_post()
    {            
        $data = json_decode( file_get_contents('php://input'),true);
        $res = new blankClass();
        if($data['code'] == '' || $data['name'] == '')
        {
            $this->response($res, REST_Controller::HTTP_BAD_REQUEST); 
        }
        else
        {
            $this->db->where('code',$data['code']);
            $this->db->or_where('name',$data['name']);
            $query = $this->db->get('taxonomy');
            if($query->num_rows() > 0)
            {
                $this->response($res, REST_Controller::HTTP_CONFLICT);
            }
            else
            {
                $this->db->insert('taxonomy',array('code'=>$data['code'],'name'=>$data['name']));
                $this->response($res, REST_Controller::HTTP_CREATED);
            }            
        }
    }
    
    public function npi_get()
    {
        $id = $this->get('id');
        $id = str_replace('_', '-', $id);
        
        $res = new blankClass();
        if($id === NULL)
        {
            $this->response($res, REST_Controller::HTTP_BAD_REQUEST); 
        }
        elseif($id)
        {
            $result= $this->doctor->getDoctorNPI($id);
            
            if($result)
            {
                $this->response(["data"=>$result], REST_Controller::HTTP_OK);
            }
            else
            {
                $return['success'] 		= false;
                $return['message'] 		= "";
                $return['error'] 		= '';
                $return['data'] 		= '';
                $this->response($return, REST_Controller::HTTP_UNAUTHORIZED);
            }
            
        }
        else 
        {
            $return['success'] 		= false;
            $return['message'] 		= "npi dosn't exist.";
            $return['error'] 		= '';
            $return['data'] 		= '';
            $this->response($return, REST_Controller::HTTP_BAD_REQUEST); 
        }
    }
    
    public function licence_get()
    {
        $id = $this->get('id');
        $id = str_replace('_', '-', $id);
        
        $res = new blankClass();
        if($id === NULL)
        {
            $this->response($res, REST_Controller::HTTP_BAD_REQUEST); 
        }
        elseif($id)
        {
            $result= $this->doctor->getDoctorLicence($id);
            
            if($result)
            {
                $this->response(["data"=>$result], REST_Controller::HTTP_OK);
            }
            else
            {
                $this->response(["data"=>array()], REST_Controller::HTTP_OK);
            }
            
        }
        else 
        {
            $this->response($res, REST_Controller::HTTP_BAD_REQUEST); 
        }
    }    
    
    public function licence_delete()
    {
        $id = $this->get('id');
        $id = str_replace('_', '-', $id);
        $lincence_id = $this->get('lincence_id');
        
        $res = new blankClass();
        if($id === NULL || $lincence_id === NULL)
        {
            $this->response($res, REST_Controller::HTTP_BAD_REQUEST); 
        }
        elseif($id && $lincence_id)
        {
            $result= $this->doctor->deleteDoctorLicence($id,$lincence_id);
            
            if($result)
            {
                $this->response([], REST_Controller::HTTP_OK);
            }
            else
            {
                $this->response($res, REST_Controller::HTTP_UNAUTHORIZED);
            }
            
        }
        else 
        {
            $this->response($res, REST_Controller::HTTP_BAD_REQUEST); 
        }
    }
    
    
    public function licence_post()
    {
        $id = $this->get('id');
        $id = str_replace('_', '-', $id);
        
        $res = new blankClass();
        if($id === NULL)
        {
            $this->response($res, REST_Controller::HTTP_BAD_REQUEST); 
        }
        elseif($id)
        {
            $data = json_decode( file_get_contents('php://input'),true);
            $result= $this->doctor->updateDoctorLicence($id,$data);
            
            if($result)
            {
                $this->response($res, REST_Controller::HTTP_OK);
            }
            else
            {
                $this->response($res, REST_Controller::HTTP_UNAUTHORIZED);
            }
            
        }
        else 
        {
            $this->response($res, REST_Controller::HTTP_BAD_REQUEST); 
        }
    }
    
    public function taxonomy_get()
    {
        $id = $this->get('id');
        $id = str_replace('_', '-', $id);
        
        $res = new blankClass();
        if($id === NULL)
        {
            $this->response($res, REST_Controller::HTTP_BAD_REQUEST); 
        }
        elseif($id)
        {
            $result= $this->doctor->getDoctorTaxonomy($id);
            
            if($result)
            {
                $this->response(["data"=>$result], REST_Controller::HTTP_OK);
            }
            else
            {
                $this->response(["data"=>array()], REST_Controller::HTTP_OK);
            }
            
        }
        else 
        {
            $this->response($res, REST_Controller::HTTP_BAD_REQUEST); 
        }
        
    }
    
    public function taxonomy_post()
    {
        $id = $this->get('id');
        $id = str_replace('_', '-', $id);
        
        $res = new blankClass();
        if($id === NULL)
        {
            $this->response($res, REST_Controller::HTTP_BAD_REQUEST); 
        }
        elseif($id)
        {
            $data = json_decode( file_get_contents('php://input'),true);
            $data['doctor_id'] = $id;
            $result = false;
            foreach($data['taxonomy_id'] as $taxonomy_id)
            {
                $result= $this->doctor->addTaxonomy(array("doctor_id"=>$id,"taxonomy_id"=>$taxonomy_id));                   
            }
            
            if($result)
            {
                $this->response($res, REST_Controller::HTTP_OK);
            }
            else
            {
                $this->response($res, REST_Controller::HTTP_UNAUTHORIZED);
            }
            
        }
        else 
        {
            $this->response($res, REST_Controller::HTTP_BAD_REQUEST); 
        }
        
    }

    public function appoinment_history_get()
    {
       $id = $this->get('id');
       $filter_date = $this->get('filter_date');
        
        if($id === NULL)
        {
            $this->response(NULL, REST_Controller::HTTP_BAD_REQUEST); 
        }
        else
        {
            $result =$this->doctor->getAppoinmentHistory($id,$filter_date);
            
            if(empty($result))
            {
                
                $this->response(["data"=>$result], REST_Controller::HTTP_NO_CONTENT);
            }
            else
            {
                $this->response(["data"=>$result], REST_Controller::HTTP_OK);
            }
            
        }
             
    }
	
}
