<?php

class Doctor_model extends CI_Model
{
    public function checkConsultActive($consult_id,$doctor_id)
    {
        $this->db->where("id",$consult_id);
        $this->db->where("(doctor_id is NULL OR doctor_id = $doctor_id)");
        $query = $this->db->get('consultation');
        if($query->num_rows() == 1)
        {
            return $query->row();
        }
        else
        {
            return false;
        }
    }
    
    public function updateConsultDoctor($consult_id,$dataConsult)
    {
        $this->db->where('id',$consult_id);
        return $this->db->update("consultation",$dataConsult);
    }
    
    public function save_answer($question_id,$dataAnswer)
    {
        $this->db->where('id',$question_id);
        return $this->db->update("consultation_question",$dataAnswer);
    }
    
    public function getActiveConsult($id)
    {
        $tmpdate = new DateTime();
        $tmpdate->sub(new DateInterval("PT3H"));
        $expected_expiry_date =  $tmpdate->format('Y-m-d H:i:s');
        
        $this->db->select("c.id, c.available_question_cnt, c.consult_code, c.end_date,  c.start_date, c.status, c.doctor_id, c.patient_id,p.first_name,p.last_name");
        $this->db->from("consultation c");
        $this->db->where('doctor_id',$id);
        $this->db->join('patient p','c.patient_id = p.id');
        //$this->db->where('c.available_question_cnt > 0');
        $this->db->where('status != 2');
        //$this->db->where('start_date >= ',$expected_expiry_date);
        $query = $this->db->get();
        
        if($query->num_rows() > 0)
        {
            return $query->result();
        }
        else
        {
            return array();
        }
    }
    
    public function getNewConsult($id)
    {
        $tmpdate = new DateTime();
        $tmpdate->sub(new DateInterval("PT3H"));
        $expected_expiry_date =  $tmpdate->format('Y-m-d H:i:s');
        
        $this->db->select("c.id, c.available_question_cnt, c.consult_code, c.end_date,  c.start_date, c.status, c.doctor_id, c.patient_id,p.first_name,p.last_name");
        $this->db->from("consultation c");
        $this->db->where('c.doctor_id IS NULL');
        $this->db->where('c.tmp_doctor_id',$id);
        $this->db->join('patient p','c.patient_id = p.id');
        $this->db->where('c.available_question_cnt > 0');
        $this->db->where('status != 2');
        $this->db->where('start_date >= ',$expected_expiry_date);
        $query = $this->db->get();
        
        if($query->num_rows() > 0)
        {
            return $query->result();
        }
        else
        {
            return array();
        }
    }
    
    public function getInActiveConsult($id)
    {
        $tmpdate = new DateTime();
        $tmpdate->sub(new DateInterval("PT3H"));
        $expected_expiry_date =  $tmpdate->format('Y-m-d H:i:s');
        
        $this->db->select("c.id, c.available_question_cnt, c.consult_code, c.end_date,  c.start_date, c.status, c.doctor_id, c.patient_id,p.first_name,p.last_name");
        $this->db->from("consultation c");
        $this->db->join('patient p','c.patient_id = p.id');
        $this->db->where('c.doctor_id',$id);
        $this->db->where("(c.available_question_cnt=0 OR status=2)");
        
        $this->db->where('start_date < ',$expected_expiry_date);
        $query = $this->db->get();
         
        if($query->num_rows() > 0)
        {
            return $query->result();
        }
        else
        {
            return array();
        }
    }
    
    public function getConsultQuestion($id)
    {
        $this->db->select("`id` as question_id, `version`, `answer`, `answered_on_date`, `asked_on_date`, `consult_for`, `modified_date`, `is_patient_viewable`, `question`, `consult_id`, `family_member_id`");
        $this->db->from("consultation_question");
        $this->db->where('consult_id',$id);
        
        $query = $this->db->get();
         
        if($query->num_rows() > 0)
        {
            return $query->result();
        }
        else
        {
            return false;
        }
    }
    
    
    public function add($data)
    {
        $data['password'] = md5($data['password']);
        $this->db->insert('user',$data);
        $user_id =  $this->db->insert_id();
        $doctor = array();
        $doctor['created_date'] = $data['created_date'];
        $doctor['first_name'] = $data['first_name'];
        $doctor['last_name'] = $data['last_name'];
        $doctor['mailing_phone'] = $data['phone_number'];
        $doctor['fcm_key'] = $data['fcm_key'];
        $doctor['device'] = $data['device'];
        $doctor['user_id'] = $user_id;
        $this->db->insert('doctor',$doctor);
        return $user_id;
    }
    
    public function userExist($email)
    {
        if($email)
        {
            $this->db->where('email',$email);
        }
        
        $query = $this->db->get('user');
        if($query->num_rows()>0)
        {
            $dataUser = $query->row();
            return $dataUser->id;
        }
        else
        {
            return false;
        }
        
    }
    
    public function validate($email,$password)
    {
        $this->db->select("d.id,u.email, u.first_name, u.last_name,d.npi_verification, u.phone_number,u.id as user_id");
        $this->db->from('user u');
        $this->db->join('doctor d','u.id = d.user_id');
        $this->db->where('u.email',$email);
        $this->db->where('(u.user_type =2 OR u.user_type =3)');
        $this->db->where('u.password', md5($password));
        $query = $this->db->get();
        //echo $this->db->last_query();die;
        if($query->num_rows() == 1)
        {
            return $query->row();
        }
        else
        {
            return false;
        }
    }
    
    public function getDetail($DriverID)
    {
        $this->db->select(" `Name`, `Phone`, `Mobile`, `EmailAddress`, `Picture`,  COALESCE(`BirthDate`,'0000-00-00') as BirthDate, `Address` ");
        $this->db->where('DriverID',$DriverID);
        $query = $this->db->get('tbldriver');
        //echo $this->db->last_query();die;
        if($query->num_rows() == 1)
        {
            return $query->row();
        }
        else
        {
            return false;
        }
    }
    
    public function matchPassword($id,$Password)
    {
        $this->db->select('u.*');
        $this->db->from('user u');
        $this->db->join('doctor d','d.user_id = u.id','LEFT');
        $this->db->where('d.id',$id);
        $this->db->where('u.password',$Password);
        $query = $this->db->get();
        if($query->num_rows() == 1)
        {
            return $query->row()->id;
        }
        else 
        {
            return false;
        }
        
    }
    
    public function resetPassword($userID,$password)
    {
        $this->db->where('id',$userID);
        return $this->db->update('user',array('password'=> md5($password)));
    }
    
    public function updateProfile($userID,$data)
    {
        if(isset($data['email']))
        {
            unset($data['email']);
            unset($data['id']);
            unset($data['password']);
        }
        $this->db->where('id',$userID);
        return $this->db->update('doctor',$data);
    }
    
    public function updateDoctorFCM($userID,$data)
    {
        $this->db->where('id',$userID);
        return $this->db->update('doctor',$data);
    }
    
    public function updateDoctor($userID,$data)
    {
        $this->db->where('id',$userID);
        return $this->db->update('user',$data);
    }
    
    public function updateNPI($userID,$data)
    {
        if(isset($data->taxonomies))
        {
            if(is_array($data->taxonomies))
            {
                $this->db->where('doctor_id',$userID);
                    $this->db->delete('doctor_npi_taxonomy'); 
                foreach ($data->taxonomies as $taxonomy)
                {
                    $taxonomy->doctor_id = $userID;
                    $this->db->insert('doctor_npi_taxonomy',$taxonomy);
                }
            }
        }
        
        if(isset($data->addresses))
        {
            if(is_array($data->addresses))
            {
                $this->db->where('doctor_id',$userID);
                $this->db->delete('doctor_npi_address');     
                foreach ($data->addresses as $addresses)
                {
                    $addresses->doctor_id = $userID;
                    $this->db->insert('doctor_npi_address',$addresses);
                }
            }
        }
        
        if(isset($data->basic))
        {            
            $basic = $data->basic;
            $this->db->where('doctor_id',$userID);
            $this->db->delete('doctor_npi_details');                    
            $basic->doctor_id = $userID;
            $this->db->insert('doctor_npi_details',$basic);
        }
    }    
    
    public function getDoctor($id)
    {
        $this->db->select("d.id,  d.credential, d.mailing_address1, d.practice_address1, d.first_name, d.gender_code, d.last_name, d.mailing_city, d.mailing_country_code, d.mailing_fax, d.mailing_postal_code, d.is_mailing_addr_same_as_practice, d.mailing_state, d.mailing_phone, d.middle_name, d.modified_date, d.npi_number,  d.paypal_address,  d.practice_cell, d.practice_city, d.practice_country_code, d.practice_fax, d.practice_postal_code, d.practice_state, d.practice_phone, d.practice_mail_address, d.practice_postal_code_latitude, d.practice_postal_code_longitude, d.mailing_address2,d.check_by_name,d.payment_mode,d.practice_address2,d.whatsapp_number,d.whatsapp_country_code,u.email");
        $this->db->from('doctor d');
        $this->db->join('user u','d.user_id = u.id','LEFT');
        $this->db->where('d.id',$id);
        $query = $this->db->get();
        if($query->num_rows() ==1)
        {
            return $query->row();
        }
        else 
        {
            false;
        }
    }
    
    public function getDoctorNPI($id)
    {
        $data = array('taxonomy'=>false,'address'=>false,'basic'=>false);
        
        $this->db->where('doctor_id',$id);
        $queryBasic = $this->db->get('doctor_npi_details');
        if($queryBasic->num_rows() > 0)
        {
            $data['basic'] = $queryBasic->row();
        }
        
        $this->db->where('doctor_id',$id);
        $queryAddress = $this->db->get('doctor_npi_address');
        if($queryAddress->num_rows() > 0)
        {
            $data['address'] = $queryAddress->result();
        }
        
        $this->db->where('doctor_id',$id);
        $queryTaxonomy = $this->db->get('doctor_npi_taxonomy');
        if($queryTaxonomy->num_rows() > 0)
        {
            $data['taxonomy'] = $queryTaxonomy->result();
        }
        
        return $data;
    }
    
    public function getDoctorLicence($id)
    {
        $this->db->select("l.id as licence_id, Date_Format(l.expiry_date,'%Y-%m-%d') As expiry_date, l.license_number, l.doctor_id, l.state_id,s.name as state_name, s.code as state_code");
        $this->db->from('doctor_license l');
        $this->db->join('state s','l.state_id = s.id','LEFT');
        $this->db->where('l.doctor_id',$id);
        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            return $query->result();
        }
        else
        {
            return false;
        }
    }
    
    public function getDoctorTaxonomy($id)
    {
        $this->db->select("dt.*,t.code,t.name");
        $this->db->from('doctor_taxonomy dt');
        $this->db->join('taxonomy t','dt.taxonomy_id = t.id','LEFT');
        $this->db->where('dt.doctor_id',$id);
        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            return $query->result();
        }
        else
        {
            return false;
        }
    }
    
    public function addTaxonomy($data)
    {
        return $this->db->insert('doctor_taxonomy',$data);
    }
    
    public function deleteTaxonomy($data)
    {
        $this->db->where($data);
        return $this->db->delete('doctor_taxonomy');
    }
    
    public function updateDoctorLicence($id,$data)
    {
        return $this->db->insert('doctor_license',$data);        
    }
    
    public function deleteDoctorLicence($id,$lincence_id)
    {
        $this->db->where("doctor_id",$id);
        $this->db->where("id",$lincence_id);
        return $this->db->delete('doctor_license');        
    }

    public function getAppoinmentHistory($id,$filterDate='')
    {
        $date= date('Y-m-d');
        $this->db->select("b.id, b.name,b.email,b.phone,b.gender,b.date,b.time,c.consult_code, c.end_date, c.start_date,p.first_name,p.last_name");
        $this->db->from("book_appointment_history b");
        $this->db->join('consultation c','b.consult_id = c.id');
        $this->db->join('patient p','b.patient_id = p.id');
        $this->db->where('b.doctor_id',$id);
        if($filterDate==0){
            $this->db->where('b.date<',$date);
        }
        if($filterDate==1){
            $this->db->where('b.date',$date);
        }
        if($filterDate==2){
            $this->db->where('b.date>',$date);
        }
        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            return $query->result();
        }
        else
        {
            return array();
        }
    }
     
}
