<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class User_model extends CI_Model {
    
    public function getPatientID($id)
    {
        $this->db->select("p.id");
        $this->db->from('patient p');
        $this->db->where('p.user_id',$id);
        $query = $this->db->get();
        
        if($query->num_rows() ==1)
        {
            return $query->row()->id;
        }
        else 
        {
            false;
        }
    }
    
    //Patient
    public function PatientExist($data)
    {
        $this->db->where('id',$data['id']);
        $query = $this->db->get('patient');
        //echo $this->db->last_query();
        if($query->num_rows() > 0)
        {
            return true;
        }
        else
        {
            return false;
        }
    }
    
    public function getPatient($id)
    {
        $this->db->select("`id`, `version`, `address1`, `address2`, `city`, `country`, `postal_code`, `province`, `allergies`,DATE_FORMAT(`birth_date`,'%Y-%m-%d') as birth_date, `is_consults_expired`, `created_date`, DATE_FORMAT(`final_consults_expiry_date`,'%Y-%m-%d') as `final_consults_expiry_date`, `first_name`, `gps_latitude`, `gps_longitude`, `last_name`, `medications`, `modified_date`, `no_of_available_cs`, `phone_number`, `postal_code_latitude`, `postal_code_longitude`, `user_id`");
        $this->db->where('id',$id);
        $query = $this->db->get('patient');
        if($query->num_rows() ==1)
        {
            return $query->row();
        }
        else 
        {
            false;
        }
    }
    
    public function updatePatient($data)
    {
        $this->db->where('id',$data['id']);
        unset($data['id']);
        return $this->db->update('patient',$data);
    }
    
    public function matchPassword($id,$Password)
    {
        $this->db->select('u.*');
        $this->db->from('user u');
        $this->db->where('u.id',$id);
        $this->db->where('u.password',$Password);
        $query = $this->db->get();
        //echo $this->db->last_query();die;
        if($query->num_rows() == 1)
        {
            return true;
        }
        else 
        {
            return false;
        }
        
    }
    
    public function updatePassword($id,$password)
    {
        $this->db->where('id',$id);
        return $this->db->update('user',array('password'=>$password));
    }

    //!Patient
    
    //Family
    public function getFamilyList($id)
    {
        $this->db->select("`id` as member_id, `allergies`,  DATE_FORMAT(`birth_date`,'%Y-%m-%d') as birth_date,  `first_name`, `last_name`, `medications`, `relationship`");
        $this->db->from('patient_family_member');
        $this->db->where('patient_id',$id);
        $query = $this->db->get();
        
        if($query->num_rows() > 0)
        {
            return $query->result();
        }
        else
        {
            return false;
        }
    }
    
    public function updateFamily($data)
    {
        $this->db->where('id',$data['member_id']);
        unset($data['member_id']);
        return $this->db->update('patient_family_member',$data);
    }
    
    public function addFamily($data)
    {
        return $this->db->insert('patient_family_member',$data); 
    }
    //!Family
}
