﻿

        'use strict';

// angular.js main app initialization
angular.module('ngMap', []);
var app = angular.module('myapp', ['ngRoute','ngMap', 'gm']).
        config(['$routeProvider', function ($routeProvider) {
                $routeProvider.
                        when('/', {
                            templateUrl: BASE_URL+'admin/dashboard',
                            controller: HomeCtrl,
                            activetab: 'Home'
                        }).
                        when('/dashboard', {
                            templateUrl: BASE_URL+'admin/dashboard',
                            controller: HomeCtrl,
                            activetab: 'Home'
                        }).
                        when('/Config', {
                            templateUrl: BASE_URL+'admin/Config',
                            controller: ConfigCtrl,
                            activetab: 'Config'
                        }).
                        when('/taxonomy', {
                            templateUrl: BASE_URL+'admin/taxonomy',
                            controller: TaxonomyCtrl,
                            activetab: 'Taxonomy'
                        }).
                        when('/state', {
                            templateUrl: BASE_URL+'admin/state',
                            controller: StateCtrl,
                            activetab: 'State'
                        }).
                        when('/zipcode', {
                            templateUrl: BASE_URL+'admin/zipcode',
                            controller: ZipcodeCtrl, 
                            activetab: 'Zipcode'
                        }).
                        when('/patient', {
                            templateUrl: BASE_URL+'admin/patient',
                            controller: PatientCtrl, 
                            activetab: 'Patient'
                        }).
                        when('/doctor', {
                            templateUrl: BASE_URL+'admin/doctor',
                            controller: DoctorCtrl, 
                            activetab: 'Doctor'
                        }).
                        when('/package', {
                            templateUrl: BASE_URL+'admin/package',
                            controller: PackageCtrl,
                            activetab: 'Package'
                        }).
                        when('/PatientDetail/:id', {
                            templateUrl:function(urlattr){
                            return BASE_URL+'admin/patientDetail/'+urlattr.id
                            },
                            controller: PatientDetail,
                            activetab: 'Patient'
                        }).
                        when('/DoctorDetail/:id', {
                            templateUrl:function(urlattr){
                            return BASE_URL+'admin/doctorDetail/'+urlattr.id
                            },
                            controller: DoctorDetail,
                            activetab: 'Doctor'
                        }).
                        otherwise({redirectTo: '/'});
            }]).run(['$rootScope', '$http', '$browser', '$timeout', "$route", function ($scope, $http, $browser, $timeout, $route) {

        $scope.$on('$routeChangeStart', function () {
            $scope.isRouteLoading = true;
            
        });

        $scope.$on("$routeChangeSuccess", function (scope, next, current) {
            $scope.part = $route.current.activetab;
        });



    }]);

app.config(['$locationProvider', function ($location) {
        $location.hashPrefix('!');
        //$location.html5Mode(true);
    }]);

app.directive('fileModel', ['$parse', function ($parse) {
    return {
        restrict: 'A',
        link: function(scope, element, attrs) {
            var model = $parse(attrs.fileModel);
            var modelSetter = model.assign;
            
            element.bind('change', function(){
                scope.$apply(function(){
                    modelSetter(scope, element[0].files[0]);
                });
            });
        }
    };
}]);




app.service('fileUpload', ['$http', function ($http) {
    
    return this.uploadFileToUrl = function(file, uploadUrl,$scope){
        var fd = new FormData();
        fd.append('file', file);
        return $http.post(uploadUrl, fd, {
            transformRequest: angular.identity,
            headers: {'Content-Type': undefined}
        })
        .success(function(response){
            $scope.FileDeatils = response;
            if(response.file_name)
            {
               // alert("File uploaded.");
            }
            else
            {
                //alert("Please select a file to upload.");
            }
            return response;
        })
        .error(function(response){
            alert("file upload faild.");
            return response;
        });
    }
}]);

app.directive("datepicker", function () {
  return {
    restrict: "A",
    require: "ngModel",
    link: function (scope, elem, attrs, ngModelCtrl) {
      var updateModel = function (dateText) {
        scope.$apply(function () {
          ngModelCtrl.$setViewValue(dateText);
        });
      };
      var options = {
        format: "yyyy-mm-dd",
        onSelect: function (dateText) {
          updateModel(dateText);
        }
      };
      elem.datepicker(options);
    }
  }
});
