
'use strict';

//Controllers
function HomeCtrl($scope, $http) 
{
    $scope.doctorTotal;
    $scope.getDoctorTotal = function(){
        
        $http.get(BASE_URL+"admin/total_doctor").then(function(response) {
            $scope.doctorTotal = response.data;
        });
    }; 
    $scope.getDoctorTotal();
	  
	  
    $scope.patientTotal;
    $scope.getPatientTotal = function(){
        
        $http.get(BASE_URL+"admin/total_patient").then(function(response) {
            $scope.patientTotal = response.data;
        });
    }; 
    $scope.getPatientTotal();
	
	$scope.packageTotal;
    $scope.getpackageTotal = function(){
        
        $http.get(BASE_URL+"admin/total_package").then(function(response) {
            $scope.packageTotal = response.data;
        });
    }; 
    $scope.getpackageTotal();
	
	$scope.displayeds;
    $scope.getPatient = function(){
        $http.get(BASE_URL+"admin/get_patient").then(function(response) {
            $scope.displayeds = response.data;
        });
    }; 
    $scope.getPatient();
	
	$scope.displays;
    $scope.getDoctor = function(){
        $http.get(BASE_URL+"admin/get_doctor").then(function(response) {
            $scope.displays = response.data;
        });
    }; 
    $scope.getDoctor();
	
}

function ConfigCtrl($scope, $http)
{
    $scope.getSettings = function(){
        
        $http.get(BASE_URL+"admin/getSettings").then(function(response) {
            //alert(JSON.stringify(response.data));
            $scope.Name = response.data.Name;
            $scope.Title = response.data.Title;
            $scope.Tagline = response.data.Tagline;
            $scope.Website = response.data.Website;
            $scope.Address = response.data.Address;
            $scope.Email = response.data.Email;
            $scope.SearchRadius = response.data.Radius;
            $scope.No_of_questions_per_session = response.data.No_of_questions_per_session;
            $scope.Price_per_consultation_session = response.data.Price_per_consultation_session;
            $scope.Consultation_session_usage_time = response.data.Consultation_session_usage_time;
            $scope.Physician_payment_accumulation_limit = response.data.Physician_payment_accumulation_limit;
        });
    }; 
    $scope.updateWebsite = function(){
        var formData = {
            'Name': $scope.Name,
            'Title': $scope.Title,
            'Tagline': $scope.Tagline,
            'Radius': $scope.SearchRadius,
            'Website': $scope.Website,
            'Address': $scope.Address,
            'Email': $scope.Email,
            'No_of_questions_per_session' : $scope.No_of_questions_per_session,
            'Price_per_consultation_session' : $scope.Price_per_consultation_session,
            'Consultation_session_usage_time' : $scope.Consultation_session_usage_time,
            'Physician_payment_accumulation_limit' : $scope.Physician_payment_accumulation_limit
        };

        $http.post('admin/updateSettings', formData).then(function (response) {
            var result  = response.data;
            if(result.message != '')
            {
                var Gritter = function () {
                    $.gritter.add({
                        title: result.title,
                        text: result.message
                    });
                    return false;
                }();
            }
            if(result.success == 1)
            {
                $scope.getSettings();
            }
            
            $(".modal").modal('hide');
        });
    };
    $scope.getSettings();
}

function TaxonomyCtrl($scope, $http)
{
    $scope.currentPage = 0;
    $scope.totalRows = 0;
    $scope.totalPages = 0;
    $scope.searchLimit = 10;
    $scope.searchname = '';

    $scope.getPrevPage = function(){
        if($scope.currentPage > 0)
        {
            $scope.currentPage = $scope.currentPage -1;
            $scope.getList();
        }
    };

    $scope.getNextPage = function(){

        if($scope.currentPage < $scope.totalPages)
        {
            $scope.currentPage = $scope.currentPage +1;
            $scope.getList();
        }
    };
    
    $scope.add = function(){
		console.log($scope.name);
		if($scope.name!='' && $scope.name!=undefined){
             var formData = {
                'name': $scope.name,
                'code': $scope.code
            };

            $http.post('admin/addTaxonomy', formData).then(function (response) {
                //alert(response.data)
                var result  = response.data;
                if(result.message != '')
                {
                    var Gritter = function () {
                        $.gritter.add({
                            title: result.title,
                            text: result.message
                        });
                        return false;
                    }();
                }
                if(result.success == 1)
                {
                    $scope.getList();
                }
                $(".modal").modal('hide');
            });
            $scope.name="";
            $scope.code="";
			$scope.searchname="";
            $scope.selectName="";
            
		}  
        };
        
    $scope.edit = function(id){
        $http.get(BASE_URL+"admin/getTaxonomy/"+id).then(function(response) {
            //alert(JSON.stringify(response.data));
            $scope.uName = response.data.name;
            $scope.uCode = response.data.code;
            $scope.TaxonomyID = response.data.id;
            
            $("#modalEdit").modal('show');
        });
    };

    $scope.update = function(){
         var formData = {
            'name': $scope.uName,
            'code': $scope.uCode,
            'id': $scope.TaxonomyID
        };

        $http.post('admin/updateTaxonomy', formData).then(function (response) {
            var result  = response.data;
            if(result.message != '')
            {
                var Gritter = function () {
                    $.gritter.add({
                        title: result.title,
                        text: result.message
                    });
                    return false;
                }();
            }
            if(result.success == 1)
            {
                $scope.getList();
            }
            $(".modal").modal('hide');
        });
        
        
    };

    $scope.getList = function(){

        $http.get(BASE_URL+"admin/TaxonomyList?search="+$scope.search).then(function(response) {
            $scope.totalRows = response.data.length;
            var tmpPage = Math.ceil($scope.totalRows/$scope.searchLimit);
            $scope.totalPages = tmpPage;
        });

        $http.get(BASE_URL+"admin/TaxonomyList?limit="+$scope.searchLimit+"&search="+$scope.search+"&page="+$scope.currentPage).then(function(response) {
            $scope.displayed = response.data;
        });
    };
    
    $scope.getList();
	
	$scope.getListFromAPI = function(){

        $http.get("https://www.hipaaspace.com/api/hptc/search?q="+$scope.searchname+"&rt=json&token=3932f3b0-cfab-11dc-95ff-0800200c9a663932f3b0-cfab-11dc-95ff-0800200c9a66").then(function(response) {
			
            $scope.searchDataList = response.data.HPTC;
            
        });

        
    };
	
	$scope.setTaxonomyData = function(){

       console.log($scope.selectName.Taxonomy);
        $scope.name=$scope.selectName.ShortName;
        $scope.code=$scope.selectName.Taxonomy;
        
    };
}

function StateCtrl($scope, $http)
{
    $scope.currentPage = 0;
    $scope.totalRows = 0;
    $scope.totalPages = 0;
    $scope.searchLimit = 10;

    $scope.getPrevPage = function(){
        if($scope.currentPage > 0)
        {
            $scope.currentPage = $scope.currentPage -1;
            $scope.getList();
        }
    };

    $scope.getNextPage = function(){

        if($scope.currentPage < $scope.totalPages)
        {
            $scope.currentPage = $scope.currentPage +1;
            $scope.getList();
        }
    };
    
    $scope.add = function(){
             var formData = {
                'name': $scope.name,
                'code': $scope.code
            };

            $http.post('admin/addState', formData).then(function (response) {
                //alert(response.data)
                var result  = response.data;
                if(result.message != '')
                {
                    var Gritter = function () {
                        $.gritter.add({
                            title: result.title,
                            text: result.message
                        });
                        return false;
                    }();
                }
                if(result.success == 1)
                {
                    $scope.getList();
                }
                $(".modal").modal('hide');
            });
            $scope.name="";
            $scope.code="";
            
        };
        
    $scope.edit = function(id){
        
        $http.get(BASE_URL+"admin/getState/"+id).then(function(response) {
            //alert(JSON.stringify(response.data));
            $scope.uName = response.data.name;
            $scope.uCode = response.data.code;
            $scope.TaxonomyID = response.data.id;
            
            $("#modalEdit").modal('show');
        });
    };

    $scope.update = function(){
         var formData = {
            'name': $scope.uName,
            'code': $scope.uCode,
            'id': $scope.TaxonomyID
        };

        $http.post('admin/updateState', formData).then(function (response) {
            var result  = response.data;
            if(result.message != '')
            {
                var Gritter = function () {
                    $.gritter.add({
                        title: result.title,
                        text: result.message
                    });
                    return false;
                }();
            }
            if(result.success == 1)
            {
                $scope.getList();
            }
            $(".modal").modal('hide');
        });
        
        
    };

    $scope.getList = function(){

        $http.get(BASE_URL+"admin/StateList?search="+$scope.search).then(function(response) {
            $scope.totalRows = response.data.length;
            var tmpPage = Math.ceil($scope.totalRows/$scope.searchLimit);
            $scope.totalPages = tmpPage;
        });

        $http.get(BASE_URL+"admin/StateList?limit="+$scope.searchLimit+"&search="+$scope.search+"&page="+$scope.currentPage).then(function(response) {
            $scope.displayed = response.data;
        });
    };
    
    $scope.getList();
}
 
function ZipcodeCtrl($scope, $http)
{
    $scope.currentPage = 0;
    $scope.totalRows = 0;
    $scope.totalPages = 0;
    $scope.searchLimit = 10;

    $scope.getPrevPage = function(){
        if($scope.currentPage > 0)
        {
            $scope.currentPage = $scope.currentPage -1;
            $scope.getList();
        }
    };

    $scope.getNextPage = function(){

        if($scope.currentPage < $scope.totalPages)
        {
            $scope.currentPage = $scope.currentPage +1;
            $scope.getList();
        }
    };
    
    $scope.add = function(){
             var formData = {
                'zip': $scope.zip,
                'city': $scope.city,
                'state': $scope.state,
                'latitude': $scope.latitude,
                'longitude': $scope.longitude
            };

            $http.post('admin/addZipCode', formData).then(function (response) {
                //alert(response.data)
                var result  = response.data;
                if(result.message != '')
                {
                    var Gritter = function () {
                        $.gritter.add({
                            title: result.title,
                            text: result.message
                        });
                        return false;
                    }();
                }
                if(result.success == 1)
                {
                    $scope.getList();
                }
                $(".modal").modal('hide');
            });
            $scope.name="";
            $scope.code="";
            
        };
		
		 $scope.lat = undefined;
  $scope.lng = undefined;
  
  $scope.$on('gmPlacesAutocomplete::placeChanged', function(){
      var location = $scope.zip.getPlace().geometry.location;
      $scope.lat = location.lat();
      $scope.lng = location.lng();
      $scope.$apply();
  });
        
    $scope.edit = function(zip){
        
        $http.get(BASE_URL+"admin/getZipCode/"+zip).then(function(response) {
            //alert(JSON.stringify(response.data));
            $scope.uzip = response.data.zip;
            $scope.ucity = response.data.city;
            $scope.ustate = response.data.state;
            $scope.ulatitude = response.data.latitude;
            $scope.ulongitude = response.data.longitude;
            $scope.editID = response.data.zip;
            
            $("#modalEdit").modal('show');
        });
    };

    $scope.update = function(){
         var formData = {
            'zip': $scope.uzip,
            'city': $scope.ucity,
            'state': $scope.ustate,
            'latitude': $scope.ulatitude,
            'longitude': $scope.ulongitude,
            'zip': $scope.editID
        };

        $http.post('admin/updateZipCode', formData).then(function (response) {
            var result  = response.data;
            if(result.message != '')
            {
                var Gritter = function () {
                    $.gritter.add({
                        title: result.title,
                        text: result.message
                    });
                    return false;
                }();
            }
            if(result.success == 1)
            {
                $scope.getList();
            }
            $(".modal").modal('hide');
        });
        
        
    };

    $scope.getList = function(){

        $http.get(BASE_URL+"admin/ZipCodeList?search="+$scope.search).then(function(response) {
            $scope.totalRows = response.data.length;
            var tmpPage = Math.ceil($scope.totalRows/$scope.searchLimit);
            $scope.totalPages = tmpPage;
        });
 
        $http.get(BASE_URL+"admin/ZipCodeList?limit="+$scope.searchLimit+"&search="+$scope.search+"&page="+$scope.currentPage).then(function(response) {
            $scope.displayed = response.data;
        });
    };
    
    $scope.getList();
} 

function PatientCtrl($scope, $http)
{
    $scope.currentPage = 0;
    $scope.totalRows = 0;
    $scope.totalPages = 0;
    $scope.searchLimit = 10;
    
    $("#birth_date").datepicker({format: "yyyy-mm-dd"}).on('changeDate', function(ev){
            if($("#birth_date").val() != '')
            {
                $scope.birth_date = $("#birth_date").val();
            }
            $('#birth_date').datepicker('hide');
        });
        
    $("#final_consults_expiry_date").datepicker({format: "yyyy-mm-dd"}).on('changeDate', function(ev){
            if($("#final_consults_expiry_date").val() != '')
            {
                $scope.final_consults_expiry_date = $("#final_consults_expiry_date").val();
            }
            
            $('#final_consults_expiry_date').datepicker('hide');
        });    

    $scope.getPrevPage = function(){
        if($scope.currentPage > 0)
        {
            $scope.currentPage = $scope.currentPage -1;
            $scope.getList();
        }
    };

    $scope.getNextPage = function(){

        if($scope.currentPage < $scope.totalPages)
        {
            $scope.currentPage = $scope.currentPage +1;
            $scope.getList();
        }
    };
    
    $scope.add = function(){
             var formData = {
                'zip': $scope.zip,
                'city': $scope.city,
                'state': $scope.state,
                'latitude': $scope.latitude,
                'longitude': $scope.longitude
            };

            $http.post('admin/addPatient', formData).then(function (response) {
                //alert(response.data)
                var result  = response.data;
                if(result.message != '')
                {
                    var Gritter = function () {
                        $.gritter.add({
                            title: result.title,
                            text: result.message
                        });
                        return false;
                    }();
                }
                if(result.success == 1)
                {
                    $scope.getList();
                }
                $(".modal").modal('hide');
            });
            $scope.name="";
            $scope.code="";
            
        };
        
    $scope.edit = function(id){
    		
        $http.get(BASE_URL+"admin/getPatient/"+id).then(function(response) {
            //alert(JSON.stringify(response.data));
            $scope.editID= response.data.id; 
            $scope.address1= response.data.address1; 
            $scope.address2= response.data.address2; 
            $scope.city= response.data.city; 
            $scope.country= response.data.country; 
            $scope.postal_code= response.data.postal_code; 
            $scope.province= response.data.province; 
            $scope.allergies= response.data.allergies; 
            $scope.birth_date= response.data.birth_date; 
            $scope.is_consults_expired= response.data.is_consults_expired; 
            $scope.created_date= response.data.created_date; 
            $scope.final_consults_expiry_date= response.data.final_consults_expiry_date; 
            $scope.first_name= response.data.first_name; 
            $scope.gps_latitude= response.data.gps_latitude; 
            $scope.gps_longitude= response.data.gps_longitude; 
            $scope.last_name= response.data.last_name; 
            $scope.medications= response.data.medications; 
            $scope.modified_date= response.data.modified_date; 
            $scope.no_of_available_cs= response.data.no_of_available_cs; 
            $scope.phone_number= response.data.phone_number; 
            $scope.postal_code_latitude= response.data.postal_code_latitude; 
            $scope.postal_code_longitude= response.data.postal_code_longitude;
            $scope.user_email= response.data.email;
            
            $("#modalEdit").modal('show');
        });
    };

    $scope.update = function(){
         var formData = {
            'address1': $scope.address1, 
            'address2': $scope.address2, 
            'city': $scope.city, 
            'country': $scope.country, 
            'postal_code': $scope.postal_code, 
            'province': $scope.province, 
            'allergies': $scope.allergies, 
            'birth_date': $scope.birth_date, 
            'is_consults_expired': $scope.is_consults_expired, 
            'created_date': $scope.created_date, 
            'final_consults_expiry_date': $scope.final_consults_expiry_date, 
            'first_name': $scope.first_name, 
            'gps_latitude': $scope.gps_latitude, 
            'gps_longitude': $scope.gps_longitude, 
            'last_name': $scope.last_name, 
            'medications': $scope.medications, 
            'modified_date': $scope.modified_date, 
            'no_of_available_cs': $scope.no_of_available_cs, 
            'phone_number': $scope.phone_number, 
            'postal_code_latitude': $scope.postal_code_latitude, 
            'postal_code_longitude': $scope.postal_code_longitude,
            'id': $scope.editID
        };

        $http.post('admin/updatePatient', formData).then(function (response) {
            var result  = response.data;
            if(result.message != '')
            {
                var Gritter = function () {
                    $.gritter.add({
                        title: result.title,
                        text: result.message
                    });
                    return false;
                }();
            }
            if(result.success == 1)
            {
                $scope.getList();
            }
            $(".modal").modal('hide');
        });
        
        
    };

    $scope.getList = function(){

        $http.get(BASE_URL+"admin/PatientList?search="+$scope.search).then(function(response) {
            $scope.totalRows = response.data.length;
            var tmpPage = Math.ceil($scope.totalRows/$scope.searchLimit);
            $scope.totalPages = tmpPage;
        });
 
        $http.get(BASE_URL+"admin/PatientList?limit="+$scope.searchLimit+"&search="+$scope.search+"&page="+$scope.currentPage).then(function(response) {
            $scope.displayed = response.data;
        });
    };
    
    $scope.getList();
} 

function PatientDetail($scope, $http,$timeout)
{
    $scope.Patient;
    $scope.FamilyList;
    $scope.Member = false;
    $scope.eMember = false;
    $scope.nMember = false;
    
    $scope.Consult;
    $scope.ConsultCode;
    $scope.ConsultQuestion;
    $scope.getConsultation = function(){
        $http.get(BASE_URL+"api/patient/consults/"+$scope.PatientID,{headers: {'X-API-KEY': 'e10adc3949ba59abbe56e057f20f883e'}}).then(function(response) {
            $scope.Consult = response.data.data;
        });
    }
    
    $scope.getConsultQuestion = function(ob){
        $scope.ConsultCode = ob.consult_code;
        $http.get(BASE_URL+"api/patient/consultQuestion/"+ob.id,{headers: {'X-API-KEY': 'e10adc3949ba59abbe56e057f20f883e'}}).then(function(response) {
            $scope.ConsultQuestion = response.data.data;
            $("#modalQuestionView").modal("show");
        });
    }
    
    $timeout(function () {
            $scope.getConsultation();            
    }, 1000);
    
    $timeout(function () {
            $scope.getPatientDetail();
            $scope.getFamilyList();
    }, 1000);
    //
    $("#BirthDate").datepicker({format: "yyyy-mm-dd"}).on('changeDate', function(ev){
            
            $scope.BirthDate = $("#BirthDate").val();
            $('#BirthDate').datepicker('hide');
        });
        
    $("#ebirth_date").datepicker({format: "yyyy-mm-dd"}).on('changeDate', function(ev){
            
            $scope.eMember.birth_date = $("#ebirth_date").val();
            $('#ebirth_date').datepicker('hide');
        });
        
    $("#nbirth_date").datepicker({format: "yyyy-mm-dd"}).on('changeDate', function(ev){
            
            $scope.nMember.birth_date = $("#nbirth_date").val();
            $('#nbirth_date').datepicker('hide');
        });
    
    $scope.getPatientDetail = function(){
        
            $http.get(BASE_URL+"admin/getPatient/"+$scope.PatientID).then(function(response) {
                        $scope.Patient = response.data;
                    });
            };
    
    $scope.addFamily = function(){
       $http.post('admin/addFamily', $scope.nMember).then(function (response) {
            var result  = response.data;
            if(result.message != '')
            {
                var Gritter = function () {
                    $.gritter.add({
                        title: result.title,
                        text: result.message
                    });
                    return false;
                }();
                $(".modal").modal('hide');
                $scope.nMember = false; 
            }
            $scope.getFamilyList();
            
        });
    };
    
    $scope.getFamilyList = function(){
        $http.get(BASE_URL+"admin/FamilyList/"+$scope.PatientID).then(function(response) {
            $scope.FamilyList = response.data;
        });
    };
        
    $scope.selectMember = function(member){
        $scope.Member = member;
    };
    
    $scope.editMember = function(member){
        $scope.eMember = member
        $("#modalFamilyEdit").modal('show');
    };
    
    $scope.updateMember = function(){
        
        $http.post('admin/updateFamily', $scope.eMember).then(function (response) {
            var result  = response.data;
            if(result.message != '')
            {
                var Gritter = function () {
                    $.gritter.add({
                        title: result.title,
                        text: result.message
                    });
                    return false;
                }();
                $(".modal").modal('hide');
            }
            
            
        });
        
        
    };   
    
    $scope.edit = function(id){
        
        $http.get(BASE_URL+"admin/getPatient/"+id).then(function(response) {
            //alert(JSON.stringify(response.data));
            $scope.editID= response.data.id; 
            $scope.address1= response.data.address1; 
            $scope.address2= response.data.address2; 
            $scope.city= response.data.city; 
            $scope.country= response.data.country; 
            $scope.postal_code= response.data.postal_code; 
            $scope.province= response.data.province; 
            $scope.allergies= response.data.allergies; 
            $scope.birth_date= response.data.birth_date; 
            $scope.is_consults_expired= response.data.is_consults_expired; 
            $scope.created_date= response.data.created_date; 
            $scope.final_consults_expiry_date= response.data.final_consults_expiry_date; 
            $scope.first_name= response.data.first_name; 
            $scope.gps_latitude= response.data.gps_latitude; 
            $scope.gps_longitude= response.data.gps_longitude; 
            $scope.last_name= response.data.last_name; 
            $scope.medications= response.data.medications; 
            $scope.modified_date= response.data.modified_date; 
            $scope.no_of_available_cs= response.data.no_of_available_cs; 
            $scope.phone_number= response.data.phone_number; 
            $scope.postal_code_latitude= response.data.postal_code_latitude; 
            $scope.postal_code_longitude= response.data.postal_code_longitude;
            $scope.user_email= response.data.email;
            
            $("#modalEdit").modal('show');
        });
    };

    $scope.update = function(){
         var formData = {
            'address1': $scope.address1, 
            'address2': $scope.address2, 
            'city': $scope.city, 
            'country': $scope.country, 
            'postal_code': $scope.postal_code, 
            'province': $scope.province, 
            'allergies': $scope.allergies, 
            'birth_date': $scope.birth_date, 
            'is_consults_expired': $scope.is_consults_expired, 
            'created_date': $scope.created_date, 
            'final_consults_expiry_date': $scope.final_consults_expiry_date, 
            'first_name': $scope.first_name, 
            'gps_latitude': $scope.gps_latitude, 
            'gps_longitude': $scope.gps_longitude, 
            'last_name': $scope.last_name, 
            'medications': $scope.medications, 
            'modified_date': $scope.modified_date, 
            'no_of_available_cs': $scope.no_of_available_cs, 
            'phone_number': $scope.phone_number, 
            'postal_code_latitude': $scope.postal_code_latitude, 
            'postal_code_longitude': $scope.postal_code_longitude,
            'id': $scope.editID
        };

        $http.post('admin/updatePatient', formData).then(function (response) {
            var result  = response.data;
            if(result.message != '')
            {
                var Gritter = function () {
                    $.gritter.add({
                        title: result.title,
                        text: result.message
                    });
                    return false;
                }();
            }
            
            $(".modal").modal('hide');
        });
        
        
    };   
            
    
} 


function DoctorCtrl($scope, $http)
{
    $scope.currentPage = 0;
    $scope.totalRows = 0;
    $scope.totalPages = 0;
    $scope.searchLimit = 10;
    
    $("#birth_date").datepicker({format: "yyyy-mm-dd"}).on('changeDate', function(ev){
            if($("#birth_date").val() != '')
            {
                $scope.birth_date = $("#birth_date").val();
            }
            $('#birth_date').datepicker('hide');
        });
        
    $("#final_consults_expiry_date").datepicker({format: "yyyy-mm-dd"}).on('changeDate', function(ev){
            if($("#final_consults_expiry_date").val() != '')
            {
                $scope.final_consults_expiry_date = $("#final_consults_expiry_date").val();
            }
            
            $('#final_consults_expiry_date').datepicker('hide');
        });    

    $scope.getPrevPage = function(){
        if($scope.currentPage > 0)
        {
            $scope.currentPage = $scope.currentPage -1;
            $scope.getList();
        }
    };

    $scope.getNextPage = function(){

        if($scope.currentPage < $scope.totalPages)
        {
            $scope.currentPage = $scope.currentPage +1;
            $scope.getList();
        }
    };
    
    $scope.add = function(){
             var formData = {
                'zip': $scope.zip,
                'city': $scope.city,
                'state': $scope.state,
                'latitude': $scope.latitude,
                'longitude': $scope.longitude
            };

            $http.post('admin/addDoctor', formData).then(function (response) {
                //alert(response.data)
                var result  = response.data;
                if(result.message != '')
                {
                    var Gritter = function () {
                        $.gritter.add({
                            title: result.title,
                            text: result.message
                        });
                        return false;
                    }();
                }
                if(result.success == 1)
                {
                    $scope.getList();
                }
                $(".modal").modal('hide');
            });
            $scope.name="";
            $scope.code="";
            
        };
        
    $scope.edit = function(id){
        
        $http.get(BASE_URL+"admin/getDoctor/"+id).then(function(response) {
            //alert(JSON.stringify(response.data));
            $scope.editID= response.data.id; 
            $scope.address1= response.data.address1; 
            $scope.address2= response.data.address2; 
            $scope.city= response.data.city; 
            $scope.country= response.data.country; 
            $scope.postal_code= response.data.postal_code; 
            $scope.province= response.data.province; 
            $scope.allergies= response.data.allergies; 
            $scope.birth_date= response.data.birth_date; 
            $scope.is_consults_expired= response.data.is_consults_expired; 
            $scope.created_date= response.data.created_date; 
            $scope.final_consults_expiry_date= response.data.final_consults_expiry_date; 
            $scope.first_name= response.data.first_name; 
            $scope.gps_latitude= response.data.gps_latitude; 
            $scope.gps_longitude= response.data.gps_longitude; 
            $scope.last_name= response.data.last_name; 
            $scope.medications= response.data.medications; 
            $scope.modified_date= response.data.modified_date; 
            $scope.no_of_available_cs= response.data.no_of_available_cs; 
            $scope.phone_number= response.data.phone_number; 
            $scope.postal_code_latitude= response.data.postal_code_latitude; 
            $scope.postal_code_longitude= response.data.postal_code_longitude;
            
            $("#modalEdit").modal('show');
        });
    };

    $scope.update = function(){
         var formData = {
            'address1': $scope.address1, 
            'address2': $scope.address2, 
            'city': $scope.city, 
            'country': $scope.country, 
            'postal_code': $scope.postal_code, 
            'province': $scope.province, 
            'allergies': $scope.allergies, 
            'birth_date': $scope.birth_date, 
            'is_consults_expired': $scope.is_consults_expired, 
            'created_date': $scope.created_date, 
            'final_consults_expiry_date': $scope.final_consults_expiry_date, 
            'first_name': $scope.first_name, 
            'gps_latitude': $scope.gps_latitude, 
            'gps_longitude': $scope.gps_longitude, 
            'last_name': $scope.last_name, 
            'medications': $scope.medications, 
            'modified_date': $scope.modified_date, 
            'no_of_available_cs': $scope.no_of_available_cs, 
            'phone_number': $scope.phone_number, 
            'postal_code_latitude': $scope.postal_code_latitude, 
            'postal_code_longitude': $scope.postal_code_longitude,
            'id': $scope.editID
        };

        $http.post('admin/updateDoctor', formData).then(function (response) {
            var result  = response.data;
            if(result.message != '')
            {
                var Gritter = function () {
                    $.gritter.add({
                        title: result.title,
                        text: result.message
                    });
                    return false;
                }();
            }
            if(result.success == 1)
            {
                $scope.getList();
            }
            $(".modal").modal('hide');
        });
        
        
    };

    $scope.getList = function(){

        $http.get(BASE_URL+"admin/DoctorList?search="+$scope.search).then(function(response) {
            $scope.totalRows = response.data.length;
            var tmpPage = Math.ceil($scope.totalRows/$scope.searchLimit);
            $scope.totalPages = tmpPage;
        });
 
        $http.get(BASE_URL+"admin/DoctorList?limit="+$scope.searchLimit+"&search="+$scope.search+"&page="+$scope.currentPage).then(function(response) {
            $scope.displayed = response.data;
        });
    };
    
    $scope.getList();
} 

function DoctorDetail($scope, $http,$timeout)
{
    $scope.Doctor;
    $scope.DoctorNPI;
    $scope.newNPI;
    $scope.DoctorLicence=false;
    $scope.StateList;
    $scope.eDoctor;
    $scope.DoctorTaxonomy;
    $scope.Taxonomy;
    
    $scope.DoctorConsult;
    $scope.DoctorConsultCode;
    $scope.DoctorConsultQuestion;
    $scope.getConsultation = function(){
        $http.get(BASE_URL+"api/doctor/consults/"+$scope.DoctorID,{headers: {'X-API-KEY': 'e10adc3949ba59abbe56e057f20f883e'}}).then(function(response) {
            $scope.DoctorConsult = response.data.data;
        });
    }
    
    $scope.getDoctorConsultQuestion = function(ob){
        $scope.DoctorConsultCode = ob.consult_code;
        $http.get(BASE_URL+"api/doctor/consultQuestion/"+ob.id,{headers: {'X-API-KEY': 'e10adc3949ba59abbe56e057f20f883e'}}).then(function(response) {
            $scope.DoctorConsultQuestion = response.data.data;
            $("#modalDoctorQuestionView").modal("show");
        });
    }
    
    $timeout(function () {
            $scope.getConsultation();            
    }, 1000);
    
    $timeout(function () {
            $scope.getDoctorDetail();
            $scope.getDoctorNPIDetail();
            $scope.getDoctorLicence();
            $scope.getDoctorTaxonomy();
            $scope.getTaxonomy();
            $scope.getState();
            
    }, 1000);
    //
    $("#BirthDate").datepicker({format: "yyyy-mm-dd"}).on('changeDate', function(ev){
            
            $scope.BirthDate = $("#BirthDate").val();
            $('#BirthDate').datepicker('hide');
        }); 
    
    $("#licenceExpiary").datepicker({format: "yyyy-mm-dd"}).on('changeDate', function(ev){
            
            $scope.DoctorLicence.expiry_date = $("#licenceExpiary").val();
            $('#licenceExpiary').datepicker('hide');
        });
        
    $("#licenceExp").datepicker({format: "yyyy-mm-dd"}).on('changeDate', function(ev){
            
            $scope.expiry_date = $("#licenceExp").val();
            $('#licenceExp').datepicker('hide');
        });
        
    
    $scope.getDoctorDetail = function(){
        
            $http.get(BASE_URL+"admin/getDoctor/"+$scope.DoctorID).then(function(response) {
                        $scope.Doctor = response.data;
                        $scope.eDoctor = response.data;
                    });
    };
    
    $scope.getNPI = function(){
        
            $http.get(BASE_URL+"admin/getNPI/"+$scope.NPINumber).then(function(response) {
                        var result = response.data;
                        var Gritter = function () {
                            $.gritter.add({
                                title: result.title,
                                text: result.message
                            });
                            return false;
                        }();
                        if(result.success == 1)
                        {
                            $("#btnGetNPI").addClass('hidden');
                            $("#btnSaveNPI").removeClass('hidden');
                        }
                        $scope.newNPI = response.data.NPI;
                    });
    };    
    
            
    $scope.getState = function(){
        
            $http.get(BASE_URL+"admin/StateList").then(function(response) {
                        $scope.StateList = response.data;
                    });
            };        
            
    $scope.getDoctorNPIDetail = function(){        
            $http.get(BASE_URL+"admin/getDoctorNPI/"+$scope.DoctorID).then(function(response) {
                        $scope.DoctorNPI = response.data;
                    });            
    }; 
    
    $scope.getDoctorTaxonomy = function(){        
            $http.get(BASE_URL+"admin/getDoctorTaxonomy/"+$scope.DoctorID).then(function(response) {
                        $scope.DoctorTaxonomy = response.data;
                    });            
    }; 
    
    $scope.getTaxonomy = function(){        
            $http.get(BASE_URL+"admin/TaxonomyList").then(function(response) {
                        $scope.Taxonomy = response.data;
                    });            
    }; 
    
    $scope.addTaxonomy = function(){
        var formData = {
            'doctor_id': $scope.DoctorID, 
            'taxonomy_id': $scope.aTaxonomy
         };
        //console.log(formData);
        $http.post('admin/addDoctorTaxonomy', formData).then(function (response) {
            var result  = response.data;
            if(result.message != '')
            {
                var Gritter = function () {
                    $.gritter.add({
                        title: result.title,
                        text: result.message
                    });
                    return false;
                }();
                $scope.getDoctorTaxonomy();
            }
            
            $(".modal").modal('hide');
        });
    };
    
    $scope.deleteTaxonomy = function(id){
        if(confirm('Do you want to delete this taxonomy?'))
        {
            var formData = {
                'doctor_id': $scope.DoctorID, 
                'taxonomy_id': id
             };
            $http.post('admin/deleteDoctorTaxonomy', formData).then(function (response) {
                var result  = response.data;
                if(result.message != '')
                {
                    var Gritter = function () {
                        $.gritter.add({
                            title: result.title,
                            text: result.message
                        });
                        return false;
                    }();
                    $scope.getDoctorTaxonomy();
                }

                $(".modal").modal('hide');
            });
        }
    };
    
    $scope.getDoctorLicence = function(){        
            $http.get(BASE_URL+"admin/getDoctorLicence/"+$scope.DoctorID).then(function(response) {
                        $scope.DoctorLicence = response.data;
                    });            
    }; 
    
    $scope.edit = function(){
        $("#modalEdit").modal('show');
    }; 
    
    $scope.editMailingAddress = function(){
        $("#modalEditMailingAddress").modal('show');
    }; 
    
    $scope.editLicence = function(){
        $("#modalEditLicance").modal('show');
    }; 
    
    $scope.addLicence = function(){
        $("#modalAddLicance").modal('show');
    }; 
    
    $scope.saveLicence = function(){
        
        var formData = {
            'license_number': $scope.license_number, 
            'state_id': $scope.state_id, 
            'expiry_date': $scope.expiry_date, 
            'doctor_id': $scope.DoctorID
        };
        //console.log(formData);
        $http.post('admin/updateDoctorLicence', formData).then(function (response) {
            var result  = response.data;
            if(result.message != '')
            {
                var Gritter = function () {
                    $.gritter.add({
                        title: result.title,
                        text: result.message
                    });
                    return false;
                }();
                $scope.getDoctorLicence();
            }
            
            $(".modal").modal('hide');
        });
    };
    
    $scope.update = function(){
         var formData = {
            'practice_cell': $scope.eDoctor.practice_cell, 
            'practice_fax': $scope.eDoctor.practice_fax, 
            'practice_phone': $scope.eDoctor.practice_phone,
			'practice_mail_address': $scope.eDoctor.practice_mail_address, 			
            'id': $scope.DoctorID
        };

        $http.post('admin/updateDoctor', formData).then(function (response) {
            var result  = response.data;
            if(result.message != '')
            {
                var Gritter = function () {
                    $.gritter.add({
                        title: result.title,
                        text: result.message
                    });
                    return false;
                }();
                $scope.getDoctorDetail();
            }
            
            $(".modal").modal('hide');
        });
        
    };
    
    $scope.updateMailingAddress = function(){
         var formData = {
            'mailing_city': $scope.eDoctor.mailing_city, 
            'mailing_state': $scope.eDoctor.mailing_state, 
            'mailing_postal_code': $scope.eDoctor.mailing_postal_code, 
            'mailing_phone': $scope.eDoctor.mailing_phone,
            'mailing_fax': $scope.eDoctor.mailing_fax,
            'mailing_address1': $scope.eDoctor.mailing_address1,
            'mailing_address2': $scope.eDoctor.mailing_address2,
            'mailing_country_code': $scope.eDoctor.mailing_country_code,
            'id': $scope.DoctorID
        };

        $http.post('admin/updateDoctor', formData).then(function (response) {
            var result  = response.data;
            if(result.message != '')
            {
                var Gritter = function () {
                    $.gritter.add({
                        title: result.title,
                        text: result.message
                    });
                    return false;
                }();
                $scope.getDoctorDetail();
            }
            
            $(".modal").modal('hide');
        });
        
    };
    
    $scope.updateDoctorLicence = function(){
         var formData = {
            'license_number': $scope.DoctorLicence.license_number, 
            'state_id': $scope.DoctorLicence.state_id, 
            'expiry_date': $scope.DoctorLicence.expiry_date, 
            'doctor_id': $scope.DoctorID
        };
        //console.log(formData);
        $http.post('admin/updateDoctorLicence', formData).then(function (response) {
            var result  = response.data;
            if(result.message != '')
            {
                var Gritter = function () {
                    $.gritter.add({
                        title: result.title,
                        text: result.message
                    });
                    return false;
                }();
                $scope.getDoctorLicence();
            }
            
            $(".modal").modal('hide');
        });
        
    };
    
    $scope.saveNPI = function(){
        
        //console.log(formData);
        $http.post('admin/updateNPI/'+$scope.DoctorID, $scope.newNPI).then(function (response) {
            var result  = response.data;
            if(result.message != '')
            {
                var Gritter = function () {
                    $.gritter.add({
                        title: result.title,
                        text: result.message
                    });
                    return false;
                }();
                $scope.getDoctorNPIDetail();
                if(result.success == 1)
                {
                    $("#btnGetNPI").removeClass('hidden');
                    $("#btnSaveNPI").addClass('hidden');
                    $scope.newNPI = false;
                }
                
            }
            
            $(".modal").modal('hide');
        });
        
    };  
            
    
} 

function PackageCtrl($scope, $http)
{
    $scope.currentPage = 0;
    $scope.totalRows = 0;
    $scope.totalPages = 0;
    $scope.searchLimit = 10;

    $scope.getPrevPage = function(){
        if($scope.currentPage > 0)
        {
            $scope.currentPage = $scope.currentPage -1;
            $scope.getList();
        }
    };

    $scope.getNextPage = function(){

        if($scope.currentPage < $scope.totalPages)
        {
            $scope.currentPage = $scope.currentPage +1;
            $scope.getList();
        }
    };
    
    $scope.add = function(){
             var formData = {
                'package_name': $scope.package_name,
                'validity_period': $scope.validity_period,
                'validity_period_unit': $scope.validity_period_unit,
                'no_of_consults':$scope.no_of_consults,
                'amount':$scope.amount
                
            };

            $http.post('admin/addPackage', formData).then(function (response) {
                //alert(response.data)
                var result  = response.data;
                if(result.message != '')
                {
                    var Gritter = function () {
                        $.gritter.add({
                            title: result.title,
                            text: result.message
                        });
                        return false;
                    }();
                }
                if(result.success == 1)
                {
                    $scope.getList();
                    $(".modal").modal('hide');
                }
                
            });
            $scope.name="";
            $scope.code="";
            
        };
        
    $scope.edit = function(id){
        $http.get(BASE_URL+"admin/getPackage/"+id).then(function(response) {
            //alert(JSON.stringify(response.data));
            $scope.upackage_name = response.data.package_name;
            $scope.uvalidity_period = response.data.validity_period;
            $scope.uvalidity_period_unit = response.data.validity_period_unit;
            $scope.uno_of_consults = response.data.no_of_consults;
            $scope.uamount = response.data.amount;
            $scope.editID = response.data.id;
            
            $("#modalEdit").modal('show');
        });
    };

    $scope.update = function(){
         var formData = {
            'package_name': $scope.upackage_name,
            'validity_period': $scope.uvalidity_period,
            'validity_period_unit': $scope.uvalidity_period_unit,
            'no_of_consults':$scope.uno_of_consults,
            'amount':$scope.uamount,
            'id': $scope.editID
        };

        $http.post('admin/updatePackage', formData).then(function (response) {
            var result  = response.data;
            if(result.message != '')
            {
                var Gritter = function () {
                    $.gritter.add({
                        title: result.title,
                        text: result.message
                    });
                    return false;
                }();
            }
            if(result.success == 1)
            {
                $scope.getList();
                $(".modal").modal('hide');
            }
            
        });
        
        
    };

    $scope.getList = function(){

        $http.get(BASE_URL+"admin/PackageList?search="+$scope.search).then(function(response) {
            $scope.totalRows = response.data.length;
            var tmpPage = Math.ceil($scope.totalRows/$scope.searchLimit);
            $scope.totalPages = tmpPage;
        });

        $http.get(BASE_URL+"admin/PackageList?limit="+$scope.searchLimit+"&search="+$scope.search+"&page="+$scope.currentPage).then(function(response) {
            $scope.displayed = response.data;
        });
    };
    
    $scope.getList();
}