<?php
defined('BASEPATH') OR exit('No direct script access allowed');

/*
| -------------------------------------------------------------------------
| URI ROUTING
| -------------------------------------------------------------------------
| This file lets you re-map URI requests to specific controller functions.
|
| Typically there is a one-to-one relationship between a URL string
| and its corresponding controller class/method. The segments in a
| URL normally follow this pattern:
|
|	example.com/class/method/id/
|
| In some instances, however, you may want to remap this relationship
| so that a different class/function is called than the one
| corresponding to the URL.
|
| Please see the user guide for complete details:
|
|	https://codeigniter.com/user_guide/general/routing.html
|
| -------------------------------------------------------------------------
| RESERVED ROUTES
| -------------------------------------------------------------------------
|
| There are three reserved routes:
|
|	$route['default_controller'] = 'welcome';
|
| This route indicates which controller class should be loaded if the
| URI contains no data. In the above example, the "welcome" class
| would be loaded.
|
|	$route['404_override'] = 'errors/page_missing';
|
| This route will tell the Router which controller/method to use if those
| provided in the URL cannot be matched to a valid route.
|
|	$route['translate_uri_dashes'] = FALSE;
|
| This is not exactly a route, but allows you to automatically route
| controller and method names that contain dashes. '-' isn't a valid
| class or method name character, so it requires translation.
| When you set this option to TRUE, it will replace ALL dashes in the
| controller and method URI segments.
|
| Examples:	my-controller/index	-> my_controller/index
|		my-controller/my-method	-> my_controller/my_method
*/
$route['default_controller'] = 'adminAuth/login';
$route['404_override'] = '';
$route['translate_uri_dashes'] = TRUE;

$route['admin/login'] 	= 'adminAuth/login'; 
$route['admin/logout'] 	= 'adminAuth/logout';


$route['api/doctor/verify_npi/(:any)'] = 'api/doctor/verify_npi/npi_number/$1';
$route['api/doctor/password/(:any)'] = 'api/doctor/password/id/$1';
$route['api/doctor/npi/(:any)'] = 'api/doctor/npi/id/$1';
$route['api/doctor/licence/(:any)'] = 'api/doctor/licence/id/$1';
$route['api/doctor/licence/(:any)/(:any)'] = 'api/doctor/licence/id/$1/lincence_id/$2';
$route['api/doctor/taxonomy/(:any)'] = 'api/doctor/taxonomy/id/$1';
$route['api/doctor/profile/(:any)'] = 'api/doctor/index/id/$1';
$route['api/doctor/fcm/(:any)'] = 'api/doctor/fcm/id/$1';
$route['api/doctor/consults/(:any)'] = 'api/doctor/consults/id/$1';
$route['api/doctor/consultQuestion/(:any)'] = 'api/doctor/consultQuestion/id/$1';

$route['api/patient/password/(:num)'] = 'api/patient/password/id/$1';
$route['api/patient/(:num)'] = 'api/patient/index/id/$1';
$route['api/patient/family'] = 'api/patient/family';
$route['api/patient/family/(:num)'] = 'api/patient/family/member_id/$1';
$route['api/patient/family_list/(:num)'] = 'api/patient/family_list/id/$1';
$route['api/patient/consults/(:num)'] = 'api/patient/consults/id/$1';
$route['api/patient/fcm/(:num)'] = 'api/patient/fcm/id/$1';
$route['api/patient/question/(:num)'] = 'api/patient/question/id/$1';
$route['api/patient/consultQuestion/(:num)'] = 'api/patient/consultQuestion/id/$1';
$route['api/patient/appoinment_history/(:num)'] = 'api/patient/appoinment_history/id/$1';
$route['api/doctor/appoinment_history/(:num)'] = 'api/doctor/appoinment_history/id/$1';
$route['api/doctor/appoinment_history/(:num)/(:any)'] = 'api/doctor/appoinment_history/id/$1/filter_date/$2';
$route['api/doctor/taxonomylist/(:any)'] = 'api/doctor/taxonomylist/id/$1';