<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class User_model extends CI_Model {
    
    public function getSettings()
    {
        $this->db->where('ID',1);
        $query = $this->db->get('tblsettings');
        
        if($query->num_rows() == 1)
        {
            return $query->row();
        }
        else
        {
            return false;
        }
    }
    
    public function updateSettings($data)
    {
        $this->db->where('ID',1);
       
        return $this->db->update('tblsettings',$data);
    }
    
    //Dashboard
    public function total_doctor()
    {
        $this->db->select("count(id) as total ");
        $query = $this->db->get('doctor');
        if($query->num_rows() > 0)
        {
            return $query->row()->total;
        }
        else
        {
            return false;
        }
    }
    
    public function total_patient()
    {
        $this->db->select("count(id) as total ");
        $query = $this->db->get('patient');
        if($query->num_rows() > 0)
        {
            return $query->row()->total;
        }
        else
        {
            return false;
        }
    }
	
	public function total_package()
    {
        $this->db->select("count(id) as total ");
        $query = $this->db->get('consult_package');
        if($query->num_rows() > 0)
        {
            return $query->row()->total;
        }
        else
        {
            return false;
        }
    }
	
	public function get_doctor()
    {
		$this->db->select("d.*,u.email,");
        $this->db->from('doctor d');
        $this->db->join('user u','d.user_id = u.id','LEFT');
        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            return $query->result_array();
        }
        else 
        {
            false;
        }
    }
	public function get_patient()
    {
		$this->db->select("p.*,u.email");
        $this->db->from('patient p');
		$this->db->join('user u','p.user_id = u.id','LEFT');
        $query = $this->db->get();
        
        if($query->num_rows() > 0)
        {
            return $query->result_array();
        }
        else 
        {
            false;
        }
		
    }
    
    
    //!Dashboard
    
    public function getUserDetails($userID)
    {
        $this->db->select("`UserID`, `UserName`, `UserEmail`, `UserPhoto`, `UserRole`, `UserStatus`");
        $this->db->where('UserID',$userID);
        $query = $this->db->get('tbluser');
        //echo $this->db->last_query();
        if($query->num_rows() == 1)
        {
            return $query->row();
        }
        else 
        {
            return false;
        }
    }
    
    
    //Taxonomy
    public function addTaxonomy($data)
    {
        return $this->db->insert('taxonomy',$data);
    }
    public function TaxonomyExist($data)
    {
        if(isset($data['name']))
        {
            unset($data['name']);
        }
        
        $this->db->where($data);
        $query = $this->db->get('taxonomy');
        //echo $this->db->last_query();
        if($query->num_rows() > 0)
        {
            return true;
        }
        else
        {
            return false;
        }
    }
    
    public function getTaxonomy($id)
    {
        $this->db->where('id',$id);
        $query = $this->db->get('taxonomy');
        if($query->num_rows() ==1)
        {
            return $query->row();
        }
        else 
        {
            false;
        }
    }
    
    public function updateTaxonomy($data)
    {
        $this->db->where('id',$data['id']);
        unset($data['id']);
        return $this->db->update('taxonomy',$data);
    }
    //!Taxonomy
    
    //State
    public function addState($data)
    {
        $data['country_id'] = -1;
        return $this->db->insert('state',$data);
    }
    public function StateExist($data)
    {
        $this->db->where($data);
        $query = $this->db->get('state');
        //echo $this->db->last_query();
        if($query->num_rows() > 0)
        {
            return true;
        }
        else
        {
            return false;
        }
    }
    
    public function getState($id)
    {
        $this->db->where('id',$id);
        $query = $this->db->get('state');
        if($query->num_rows() ==1)
        {
            return $query->row();
        }
        else 
        {
            false;
        }
    }
    
    public function updateState($data)
    {
        $this->db->where('id',$data['id']);
        unset($data['id']);
        return $this->db->update('state',$data);
    }
    //!State
    
    //ZipCode
    public function addZipCode($data)
    {
        $data['city'] = ucfirst($data['city']);
        $data['state'] = strtoupper($data['state']);
        return $this->db->insert('us_zip_code',$data);
    }
    public function ZipCodeExist($data)
    {
        $this->db->where('zip',$data['zip']);
        $query = $this->db->get('us_zip_code');
        //echo $this->db->last_query();
        if($query->num_rows() > 0)
        {
            return true;
        }
        else
        {
            return false;
        }
    }
    
    public function getZipCode($zip)
    {
        $this->db->where('zip',$zip);
        $query = $this->db->get('us_zip_code');
        if($query->num_rows() ==1)
        {
            return $query->row();
        }
        else 
        {
            false;
        }
    }
    
    public function updateZipCode($data)
    {
        $data['city'] = ucfirst($data['city']);
        $data['state'] = strtoupper($data['state']);
        $this->db->where('zip',$data['zip']);
        unset($data['zip']);
        return $this->db->update('us_zip_code',$data);
    }
    //!ZipCode
    
    //Patient
    public function PatientExist($data)
    {
        $this->db->where('id',$data['id']);
        $query = $this->db->get('patient');
        //echo $this->db->last_query();
        if($query->num_rows() > 0)
        {
            return true;
        }
        else
        {
            return false;
        }
    }
    
    public function getPatient($id)
    {
        $this->db->select("`p.id`, `p.version`, `p.address1`, `p.address2`, `p.city`, `p.country`, `p.postal_code`, `p.province`, `p.allergies`,DATE_FORMAT(`birth_date`,'%Y-%m-%d') as `birth_date`, `p.is_consults_expired`, `p.created_date`, DATE_FORMAT(`final_consults_expiry_date`,'%Y-%m-%d') as `final_consults_expiry_date`, `p.first_name`, `p.gps_latitude`, `p.gps_longitude`, `p.last_name`, `p.medications`, `p.modified_date`, `p.no_of_available_cs`, `p.phone_number`, `p.postal_code_latitude`, `p.postal_code_longitude`, `p.user_id`,`u.email`");
		$this->db->join('user u','p.user_id = u.id','LEFT');
        $this->db->where('p.id',$id);
        $query = $this->db->get('patient p');
		/* echo $str = $this->db->last_query();
		die; */
        if($query->num_rows() ==1)
        {
            return $query->row();
        }
        else 
        {
            false;
        }
    }
    
    public function updatePatient($data)
    {
        $this->db->where('id',$data['id']);
        unset($data['id']);
        return $this->db->update('patient',$data);
    }
    //!Patient
    
    //Family
    public function getFamilyList($id)
    {
        $this->db->select("`id` as member_id, `allergies`,  DATE_FORMAT(`birth_date`,'%Y-%m-%d') as birth_date,  `first_name`, `last_name`, `medications`, `relationship`");
        $this->db->from('patient_family_member');
        $this->db->where('patient_id',$id);
        $query = $this->db->get();
        
        if($query->num_rows() > 0)
        {
            return $query->result();
        }
        else
        {
            return false;
        }
    }
    
    public function updateFamily($data)
    {
        $this->db->where('id',$data['member_id']);
        unset($data['member_id']);
        return $this->db->update('patient_family_member',$data);
    }
    
    public function addFamily($data)
    {
        return $this->db->insert('patient_family_member',$data); 
    }
    //!Family
    
    //Doctor
    public function DoctorExist($data)
    {
        $this->db->where('id',$data['id']);
        $query = $this->db->get('doctor');
        //echo $this->db->last_query();
        if($query->num_rows() > 0)
        {
            return true;
        }
        else
        {
            return false;
        }
    }
    
    public function getDoctor($id)
    {
        $this->db->select("d.*,u.email");
        $this->db->from('doctor d');
        $this->db->join('user u','d.user_id = u.id','LEFT');
        $this->db->where('d.id',$id);
        $query = $this->db->get();
        if($query->num_rows() ==1)
        {
            return $query->row();
        }
        else 
        {
            false;
        }
    }   
        
    public function updateDoctor($data)
    {
        $this->db->where('id',$data['id']);
        unset($data['id']);
        return $this->db->update('doctor',$data);
    }          
    
    public function updateNPI($userID,$data)
    {
        //print_r($data);die;
        if(isset($data->taxonomies))
        {
            if(is_array($data->taxonomies))
            {
                $this->db->where('doctor_id',$userID);
                    $this->db->delete('doctor_npi_taxonomy'); 
                foreach ($data->taxonomies as $taxonomy)
                {
                    $taxonomy->doctor_id = $userID;
                    $this->db->insert('doctor_npi_taxonomy',$taxonomy);
                }
            }
        }
        
        if(isset($data->addresses))
        {
            if(is_array($data->addresses))
            {
                $this->db->where('doctor_id',$userID);
                $this->db->delete('doctor_npi_address');     
                foreach ($data->addresses as $addresses)
                {
                    $addresses->doctor_id = $userID;
                    $this->db->insert('doctor_npi_address',$addresses);
                }
            }
        }
        
        if(isset($data->basic))
        {            
            $basic = $data->basic;
            $this->db->where('doctor_id',$userID);
            $this->db->delete('doctor_npi_details');                    
            $basic->doctor_id = $userID;
            return $this->db->insert('doctor_npi_details',$basic);
        }
    }
    
    public function getDoctorID($id)
    {
        $this->db->select("d.id");
        $this->db->from('doctor d');
        $this->db->where('d.user_id',$id);
        $query = $this->db->get();
        
        if($query->num_rows() ==1)
        {
            return $query->row()->id;
        }
        else 
        {
            false;
        }
    }
    
    public function getDoctorNPI($id)
    {
        $data = array('taxonomy'=>false,'address'=>false,'basic'=>false);
        
        $this->db->where('doctor_id',$id);
        $queryBasic = $this->db->get('doctor_npi_details');
        if($queryBasic->num_rows() > 0)
        {
            $data['basic'] = $queryBasic->row();
        }
        
        $this->db->where('doctor_id',$id);
        $queryAddress = $this->db->get('doctor_npi_address');
        if($queryAddress->num_rows() > 0)
        {
            $data['address'] = $queryAddress->result();
        }
        
        $this->db->where('doctor_id',$id);
        $queryTaxonomy = $this->db->get('doctor_npi_taxonomy');
        if($queryTaxonomy->num_rows() > 0)
        {
            $data['taxonomy'] = $queryTaxonomy->result();
        }
        
        return $data;
    }
    
    public function getDoctorLicence($id)
    {
        $this->db->select(" Date_Format(l.expiry_date,'%Y-%m-%d') As expiry_date, l.id,l.license_number, l.doctor_id, l.state_id,s.name as state_name, s.code as state_code");
        $this->db->from('doctor_license l');
        $this->db->join('state s','l.state_id = s.id','LEFT');
        $this->db->where('l.doctor_id',$id);
        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            return $query->result();
        }
        else
        {
            return array();
        }
    }
    
    public function getDoctorTaxonomy($id)
    {
        $this->db->select("dt.*,t.code,t.name");
        $this->db->from('doctor_taxonomy dt');
        $this->db->join('taxonomy t','dt.taxonomy_id = t.id','LEFT');
        $this->db->where('dt.doctor_id',$id);
        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            return $query->result();
        }
        else
        {
            return false;
        }
    }
    
    public function addDoctorTaxonomy($data)
    {
        return $this->db->insert('doctor_taxonomy',$data);
    }
    
    public function deleteDoctorTaxonomy($data)
    {
        $this->db->where($data);
        return $this->db->delete('doctor_taxonomy');
    }    
    
    public function updateDoctorLicence($data)
    {
        $this->db->where('id',$data['id']);
        $query = $this->db->get('doctor_license');
        if($query->num_rows() ==1)
        {
            $this->db->where('id',$data['id']);
            unset($data['id']);
            return $this->db->update('doctor_license',$data);
        }
        else
        {
            return $this->db->insert('doctor_license',$data);
        }
    }
    public function addDoctorLicence($data)
    {
        return $this->db->insert('doctor_license',$data);
    }
    //!Doctor
    
    //Package
    public function updatePackageCode($id)
    {
        $tmp_str = 'PK';
       for($i=0;$i <= (4 - strlen($id));$i++)
       {
           $tmp_str = $tmp_str.'0';
       }
       
       $tmp_str = $tmp_str.$id;
       $this->db->where('id',$id);
       $this->db->update('consult_package',array('package_code'=>$tmp_str));
    }
    
    public function addPackage($data)
    {
        $data['created_date'] = date('Y-m-d H:i:s');
        $this->db->insert('consult_package',$data);
        $insert_id = $this->db->insert_id();
        $this->updatePackageCode($insert_id);
        return $insert_id;
    }
    public function PackageExist($data)
    {
        if(isset($data['package_name']))
        {
            unset($data['package_name']);
        }
        
        $this->db->where($data);
        $query = $this->db->get('consult_package');
        //echo $this->db->last_query();
        if($query->num_rows() > 0)
        {
            return true;
        }
        else
        {
            return false;
        }
    }
    
    public function getPackage($id)
    {
        $this->db->where('id',$id);
        $query = $this->db->get('consult_package');
        if($query->num_rows() ==1)
        {
            return $query->row();
        }
        else 
        {
            false;
        }
    }
    
    public function updatePackage($data)
    {
        $this->db->where('id',$data['id']);
        unset($data['id']);
        return $this->db->update('consult_package',$data);
    }
    
    public function makeDefaultDoctor($data)
    {
        $this->db->where('id',$data['id']);
        $query = "UPDATE `doctor` SET `is_default_doctor` = IF( `id` ={$data["id"]} , 1 , 0)";
        return $this->db->query($query);
    }  
    
}
