<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Patient extends CI_Controller {

    public function __construct() {
        parent::__construct();
        if ($this->session->userdata('is_logged_in') != true || $this->session->userdata('user_role') != 1) {
            redirect('login');
        }
        $this->load->model('user_model','user');
    }

    public function index() {

        $page = "Patient";
        $data['title'] = ucfirst($page);
        $userdata = $this->session->userdata('user_data');
        $data['user_name'] = $userdata->first_name;
        $data['menu'] = "dashboard";

        $this->load->view('index', $data);
    }

    //Dashboard
    public function dashboard() {
        $userdata = $this->session->userdata('user_data');
        $data['user_name'] = $userdata->first_name;
        $this->load->view('dashboard',$data);
    }
    
    public function consultation() {
        $userData = $this->session->userdata('user_data');
        
        $data['PatientID'] = $this->user->getPatientID($userData->id);
        $this->load->view('consultation',$data); 
    }
    
    public function profile() {
        $userData = $this->session->userdata('user_data');
        
        $data['PatientID'] = $this->user->getPatientID($userData->id);
        $this->load->view('patient-detail',$data); 
    }
    
    //Patient
    public function patient()
    {
        $this->load->view('patient'); 
    }

    public function patientDetail($id)
    {
        $id = str_replace('_', '-', $id);
        $data['PatientID'] = $id;
        $this->load->view('patient-detail',$data); 
    }
    
    public function FamilyList($id)
    {
        $id = str_replace('_', '-', $id);
        $data = $this->user->getFamilyList($id);
        echo json_encode($data);
    }
    
    public function addFamily()
    {
        $data = json_decode( file_get_contents('php://input'),true);
        $response = array("success"=>'',"error"=>'',"title"=>'',"message"=>'');
        //print_r($data);die;
        if($this->user->addFamily($data))
        {
            $response['success']=1;
            $response['title']= "Success";
            $response['message']= "Added successfuly.";
        }
        else
        {
            $response['error']=1;
            $response['title']= "Error";
            $response['message']= "Some error happen!";
        }
        echo json_encode($response);
    }
    
    public function updateFamily()
    {
        $data = json_decode( file_get_contents('php://input'),true);
        $response = array("success"=>'',"error"=>'',"title"=>'',"message"=>'');
        //print_r($data);die;
        if($this->user->updateFamily($data))
        {
            $response['success']=1;
            $response['title']= "Success";
            $response['message']= "Updated successfuly.";
        }
        else
        {
            $response['error']=1;
            $response['title']= "Error";
            $response['message']= "Some error happen!";
        }
        echo json_encode($response);
    }
    
    public function PatientList()
    {
        $this->db->from('patient m');
        
        if(isset($_GET['search']))
        {
            if($_GET['search'] != 'undefined')
            {
                $s = $_GET['search'];
                $this->db->where("m.first_name like '$s%' OR  m.last_name like '$s%' OR m.phone_number like '%$s%' ");
            }
        } 
        
        if(isset($_GET['limit']))
        {
            if($_GET['limit'] !='undefined')
                $this->db->limit($_GET['limit'],$_GET['page']*$_GET['limit']);
        }
        
        
        //$this->db->order_by("id","desc");
        
        $query = $this->db->get();
        $result = array();
        if($query->num_rows() > 0)
        {
            $result = $query->result();
        }
        
        echo json_encode($result);
    }
    
    public function getPatient($id)
    {
        $id = str_replace('_', '-', $id);
        $data = $this->user->getPatient($id);
        echo json_encode($data);
    }  
    
    public function updatePatient()
    {
        $data = json_decode( file_get_contents('php://input'),true);
        $response = array("success"=>'',"error"=>'',"title"=>'',"message"=>'');
        
        if($this->user->updatePatient($data))
        {
            $response['success']=1;
            $response['title']= "Success";
            $response['message']= "Updated successfuly.";
        }
        else
        {
            $response['error']=1;
            $response['title']= "Error";
            $response['message']= "Some error happen!";
        }
        echo json_encode($response);
    }
    
    
    public function updatePassword()
    {
        $data = json_decode( file_get_contents('php://input'),true);
        $response = array("success"=>'',"error"=>'',"title"=>'',"message"=>'');
        
        $data = $this->security->xss_clean($data);
        $this->form_validation->set_data($data);
        $this->form_validation->set_rules('oldpassword', 'Old Password', 'trim|required');
        $this->form_validation->set_rules('newpassword', 'New Password', 'trim|required');
        $this->form_validation->set_rules('confirmpassword', 'Confirm Password', 'trim|required|matches[newpassword]');
        
        $error = array();
        if ($this->form_validation->run() === False) {
            $error = validation_errors();
            $response['error']=1;
            $response['title']= "Error";
            $response['message']= $error;
        }
        else
        {
            $userData = $this->session->userdata('user_data');
            if($this->user->matchPassword($userData->id, md5($data['oldpassword'])))
            {
                if($this->user->updatePassword($userData->id,md5($data['newpassword'])))
                {
                    $response['success']=1;
                    $response['title']= "Success";
                    $response['message']= "Password updated successfuly.";
                }
                else
                {
                    $response['error']=1;
                    $response['title']= "Error";
                    $response['message']= "Some error happen!";
                }
            }
            else
            {
                $response['error']=1;
                $response['title']= "Error";
                $response['message']= "Old password did not match.";
            }
        }
        echo json_encode($response);
    }
    //!Patient
}
