'use strict';

// angular.js main app initialization
angular.module('ngMap', []);
var app = angular.module('myapp', ['ngRoute','ngMap']).
        config(['$routeProvider', function ($routeProvider) {
                $routeProvider.
                        when('/', {
                            templateUrl: BASE_URL+'doctor/dashboard',
                            controller: HomeCtrl,
                            activetab: 'Home'
                        }).
                        when('/dashboard', {
                            templateUrl: BASE_URL+'doctor/dashboard',
                            controller: HomeCtrl,
                            activetab: 'Home'
                        }).
                        when('/consultation', {
                            templateUrl: BASE_URL+'doctor/consultation',
                            controller: ConsultationCtrl,
                            activetab: 'Consultation'
                        }).
                        when('/profile', {
                            templateUrl: BASE_URL+'doctor/profile',
                            controller: ProfileCtrl,
                            activetab: 'Profile'
                        }).
                        otherwise({redirectTo: '/'});
            }]).run(['$rootScope', '$http', '$browser', '$timeout', "$route", function ($scope, $http, $browser, $timeout, $route) {

        $scope.$on('$routeChangeStart', function () {
            $scope.isRouteLoading = true;
            
        });

        $scope.$on("$routeChangeSuccess", function (scope, next, current) {
            $scope.part = $route.current.activetab;
        });



    }]);

app.config(['$locationProvider', function ($location) {
        $location.hashPrefix('!');
        //$location.html5Mode(true);
    }]);

app.directive('fileModel', ['$parse', function ($parse) {
    return {
        restrict: 'A',
        link: function(scope, element, attrs) {
            var model = $parse(attrs.fileModel);
            var modelSetter = model.assign;
            
            element.bind('change', function(){
                scope.$apply(function(){
                    modelSetter(scope, element[0].files[0]);
                });
            });
        }
    };
}]);




app.service('fileUpload', ['$http', function ($http) {
    
    return this.uploadFileToUrl = function(file, uploadUrl,$scope){
        var fd = new FormData();
        fd.append('file', file);
        return $http.post(uploadUrl, fd, {
            transformRequest: angular.identity,
            headers: {'Content-Type': undefined}
        })
        .success(function(response){
            $scope.FileDeatils = response;
            if(response.file_name)
            {
               // alert("File uploaded.");
            }
            else
            {
                //alert("Please select a file to upload.");
            }
            return response;
        })
        .error(function(response){
            alert("file upload faild.");
            return response;
        });
    }
}]);

app.directive("datepicker", function () {
  return {
    restrict: "A",
    require: "ngModel",
    link: function (scope, elem, attrs, ngModelCtrl) {
      var updateModel = function (dateText) {
        scope.$apply(function () {
          ngModelCtrl.$setViewValue(dateText);
        });
      };
      var options = {
        format: "yyyy-mm-dd",
        onSelect: function (dateText) {
          updateModel(dateText);
        }
      };
      elem.datepicker(options);
    }
  }
});
