<?php

defined('BASEPATH') OR exit('No direct script access allowed');


require APPPATH . '/libraries/REST_Controller.php';

class Patient extends REST_Controller {

    function __construct()
    {
        parent::__construct();

        $this->load->model('patient_model','patient');
    }
    
    public function index_put()
    {
        $id = $this->get('id');
        $id = str_replace('_', '-', $id);
        $data = json_decode( file_get_contents('php://input'),true);
        $res = new blankClass();
        if($id === NULL)
        {
            $return['success'] 		= false;
            $return['message'] 		= "User does not exist.";
            $return['error'] 		= '';
            $return['data'] 		= '';
            $this->response($return, REST_Controller::HTTP_BAD_REQUEST); 
        }
        elseif($id)
        {
            $result= $this->patient->updatePatientProfile($id,$data);
            
            if($result)
            {
                $return['success'] 		= true;
                $return['message'] 		= "Update profile successfully.";
                $return['error'] 		= '';
                $return['data'] 		= '';
                $this->response($return, REST_Controller::HTTP_OK);
            }
            else
            {
                $return['success'] 		= false;
                $return['message'] 		= "Something went wrong";
                $return['error'] 		= '';
                $return['data'] 		= '';
                $this->response($return, REST_Controller::HTTP_UNAUTHORIZED);
            }
            
        }
        else 
        {
            $this->response($res, REST_Controller::HTTP_BAD_REQUEST); 
        }
    }
    
    public function index_get()
    {
        $id = $this->get('id');
        
        if($id === NULL)
        {
            $return['success'] 		= false;
            $return['message'] 		= "User does not exist.";
            $return['error'] 		= '';
            $return['data'] 		= '';
            $this->response($return, REST_Controller::HTTP_BAD_REQUEST); 
        }
        else
        {
            $result = $this->patient->getDetail($id);
            
            if(empty($result))
            {
               
                $this->response(["data"=>$result], REST_Controller::HTTP_NO_CONTENT);
            }
            else
            {
                $this->response(["data"=>$result], REST_Controller::HTTP_OK);
            }
            
        }
    }    
    
    public function family_post()
    {
        $data = json_decode( file_get_contents('php://input'),true);
        $res = new blankClass();
        if(isset($data['id']))
        {
            $result= $this->patient->addFamily($data);
            if($result)
            {
                $return['success'] 		= true;
                $return['message'] 		= "Family member added successfully.";
                $return['error'] 		= '';
                $return['data'] 		= '';
                $this->response($return, REST_Controller::HTTP_OK);
            }
            else
            {
                $return['success'] 		= false;
                $return['message'] 		= "Something went wrong.";
                $return['error'] 		= '';
                $return['data'] 		= '';
                $this->response($return, REST_Controller::HTTP_INTERNAL_SERVER_ERROR);
            }
        }
        else
        {
            $return['success'] 		= false;
            $return['message'] 		= "Patient is not exist,";
            $return['error'] 		= '';
            $return['data'] 		= '';
            $this->response($return, REST_Controller::HTTP_BAD_REQUEST);
        }
    }
    
    public function family_put()
    {
        $data = json_decode( file_get_contents('php://input'),true);
        $res = new blankClass();
        if(!isset($data['id']) || !isset($data['member_id']))
        {
            $return['success'] 		= false;
            $return['message'] 		= "Family member not exist.";
            $return['error'] 		= '';
            $return['data'] 		= '';
            $this->response($return, REST_Controller::HTTP_BAD_REQUEST); 
        }
        else
        {

            $result= $this->patient->updateFamily($data);
            
            if($result)
            {

                $return['success'] 		= true;
                $return['message'] 		= "Family member updated successfully.";
                $return['error'] 		= '';
                $return['data'] 		= '';
                $this->response($return, REST_Controller::HTTP_OK);
            }
            else
            {
                $return['success'] 		= false;
                $return['message'] 		= "Something went wrong.";
                $return['error'] 		= '';
                $return['data'] 		= '';
                $this->response($return, REST_Controller::HTTP_INTERNAL_SERVER_ERROR);
            }
        }
    }   
        
    public function family_delete()
    {
        $id = $this->get('member_id');
        
        if($id === NULL)
        {
            $this->response(NULL, REST_Controller::HTTP_BAD_REQUEST); 
        }
        else
        {
            $result = $this->patient->deleteFamily($id);
            
            if($result)
            {
                
                $this->response(["data"=>$result], REST_Controller::HTTP_OK);
            }
            else
            {
                $this->db->where('family_member_id',$id);
                $query = $this->db->get('consultation_question');
                if($query->num_rows() > 0)
                {
                    $this->response(["data"=>$result,"message"=>"This member is already associated with some consult, You cannot delete this member."], REST_Controller::HTTP_OK);
                }
                else
                {
                    $this->response(["data"=>$result], REST_Controller::HTTP_OK);
                }
            }
            
        }
    }
    
    public function family_get()
    {
        $id = $this->get('member_id');
        
        if($id === NULL)
        {
            $this->response(NULL, REST_Controller::HTTP_BAD_REQUEST); 
        }
        else
        {
            $result = $this->patient->getFamily($id);
            
            if(empty($result))
            {
                
                $this->response(["data"=>$result], REST_Controller::HTTP_NO_CONTENT);
            }
            else
            {
                $this->response(["data"=>$result], REST_Controller::HTTP_OK);
            }
            
        }
    }
    
    public function family_list_get()
    {
        $id = $this->get('id');
        
        if($id === NULL)
        {
            $this->response(NULL, REST_Controller::HTTP_BAD_REQUEST); 
        }
        else
        {
            $result = $this->patient->getFamilyList($id);
            
            if(empty($result))
            {
                
                $this->response(["data"=>$result], REST_Controller::HTTP_OK);
            }
            else
            {
                $this->response(["data"=>$result], REST_Controller::HTTP_OK);
            }
            
        }
    }
    
    public function password_put()
    {
        $id = $this->get('id');
        $id = str_replace('_', '-', $id);
        $data = json_decode(file_get_contents('php://input'), true);
        $res = new blankClass();
        
        if($id && isset($data['password']) && isset($data['oldpassword']))
        {
            $_POST = $data;
            
            $resMatch = $this->patient->matchPassword($id,md5($data['oldpassword']));
            
            if($resMatch)
            {
                unset($data['oldpassword']);
                $data['password'] = md5($data['password']);
                if($this->patient->updatePatient($resMatch,$data))
                {
                    $return['success'] 		= true;
                    $return['message'] 		= "Password changed successfully.";
                    $return['error'] 		= '';
                    $return['data'] 		= '';
                    $this->response($return, REST_Controller::HTTP_OK);
                }
                else
                {
                    $return['success'] 		= false;
                    $return['message'] 		= "Some thing went wrong.";
                    $return['error'] 		= '';
                    $return['data'] 		= '';
                    $this->response($return, REST_Controller::HTTP_NOT_MODIFIED);
                }
            }
            else
            {
                $return['success'] 		= false;
                $return['message'] 		= "Old password not matched.";
                $return['error'] 		= '';
                $return['data'] 		= '';
                $this->response($return, REST_Controller::HTTP_UNAUTHORIZED);
            }
            
        }
        else 
        {
            $return['success'] 		= false;
            $return['message'] 		= "Some thing went wrong.";
            $return['error'] 		= '';
            $return['data'] 		= '';
            $this->response($return, REST_Controller::HTTP_BAD_REQUEST); 
        }
    }
    
    public function logout_get()
    {
        $PassengerID = $this->get('PassengerID');
        
        if($PassengerID === NULL)
        {
            $this->response(NULL, REST_Controller::HTTP_BAD_REQUEST); 
        }
        else
        {
            $this->db->where('PassengerID',$PassengerID);
                
            $result = $this->db->update('tblpassenger',array('LoggedIn'=>0));
            
            if($result)
            {
               $this->response([], REST_Controller::HTTP_OK);
            }
            else
            {
                $this->response(NULL, REST_Controller::HTTP_BAD_REQUEST); 
            }
            
        }
    }
    
    public function fcm_put()
    {
        $id = $this->get('id');
        $id = str_replace('_', '-', $id);
        $data = json_decode( file_get_contents('php://input'),true);
        if($id && isset($data['fcm_key']))
        {
			
            if($this->patient->updatePatientFCM($id,$data))
            {
                $this->response('', REST_Controller::HTTP_OK);
            }
            else
            {
                $this->response('', REST_Controller::HTTP_NOT_MODIFIED);
            }
            
        }
        else 
        {
            $this->response(NULL, REST_Controller::HTTP_BAD_REQUEST); 
        }
    }
    
    public function consults_get()
    {
        $id = $this->get('id');
        
        if($id === NULL)
        {
            $this->response(NULL, REST_Controller::HTTP_BAD_REQUEST); 
        }
        else
        {
            $result = array('available_consult'=>0,'active_consult'=>'');
            
            $total = $this->patient->getAvailableConsult($id);
            $used =$this->patient->getUsedConsult($id);
            if($total>=$used){
            $result['available_consult'] = $total-$used;
            }
            $result['expected_expiry_date'] = $this->patient->getConsultExpiery($id); 
            $result['active_consult'] = $this->patient->getActiveConsult($id);
            $result['inactive_consult'] = $this->patient->getInActiveConsult($id); 
            
            
            if(empty($result))
            {
                
                $this->response(["data"=>[]], REST_Controller::HTTP_NO_CONTENT);
            }
            else
            {
                $this->response(["data"=>$result], REST_Controller::HTTP_OK);
            }
            
        }
             
    }
    
    public function close_consult_post()
    {
        $data = json_decode( file_get_contents('php://input'),true);
        $res = new blankClass();
        if(isset($data['consult_id']) && isset($data['patient_id'])  && isset($data['doctor_id']))
        {
            $result = $this->patient->closeConsult($data['patient_id'],$data['consult_id']);
            if($result)
            {
                $doctorDetail = $this->patient->getDoctorDetails($data['doctor_id']);
                $this->response(["data"=>$doctorDetail], REST_Controller::HTTP_OK);
            }
            else
            {
                $this->response($res, REST_Controller::HTTP_INTERNAL_SERVER_ERROR);
            }
        }
        else
        {
            $this->response($res, REST_Controller::HTTP_BAD_REQUEST);
        }
    }
    
    public function consultQuestion_get()
    {
        $id = $this->get('id');
        if($id === NULL)
        {
            $this->response(NULL, REST_Controller::HTTP_BAD_REQUEST); 
        }
        else
        {   
            $result = $this->patient->getConsultQuestion($id);
            if(empty($result))
            {
                
                $this->response(["data"=>$result], REST_Controller::HTTP_NO_CONTENT);
            }
            else
            {
                $this->response(["data"=>$result], REST_Controller::HTTP_OK);
            }
            
        }
    }
    
    public function createConsult($data,$doctor_id)
    {
        $this->db->select('max(id) as id');
        $this->db->from('consultation');
        $query = $this->db->get();
        $currentID = $query->row()->id;
        $settings = $this->session->userdata('Settings');
       // print_r($settings);die;
        $currentDateTime = date("Y-m-d H:i:s");
        $tmpdate = new DateTime();
        $tmpdate->add(new DateInterval("PT".$settings->Consultation_session_usage_time."H"));
        $end_date =  $tmpdate->format('Y-m-d H:i:s');
        
        $csData = array(
            'available_question_cnt'=>3,
            'consult_code'=>'CS000'.(++$currentID),
            'patient_latitude'=>$data['patient_latitude'],
            'patient_longitude'=>$data['patient_longitude'],
            'patient_state_code'=>$data['patient_state_code'],
            'status'=>0,
            'start_date'=>$currentDateTime,
            //'end_date'=>$end_date,
            'patient_id'=>$data['patient_id'],
            'tmp_doctor_id'=>$doctor_id
            );
        $this->db->insert('consultation',$csData);
        return $this->db->insert_id();       
        
    }
    
    public function question_post()
    {
        $data = json_decode( file_get_contents('php://input'),true);
        //print_r($data);die;
        $res = new blankClass();
        $doctor_id;
        $doctor_fcm;
        $consult_id;
        if(!isset($data['consult_id']))
        {     
            $doctor = $this->patient->getNearestDoctor($data['patient_latitude'],$data['patient_longitude']);
            
//            if(!$doctor)
//            {
//                $doctor = $this->patient->getDefaultDoctor($data['patient_latitude'],$data['patient_longitude']);                
//            }
            
            $doctor_id = $doctor->id;
            $doctor_fcm = $doctor->fcm_key;
            
            $consult_id = $this->createConsult($data,$doctor_id); 
        }
        else
        {
            $doctor = $this->patient->getConsultDoctor($data['consult_id']);
            //echo $this->db->last_query();
            if(!$doctor ){
                $return['success'] 		= false;
                $return['message'] 		= "Doctor is not avaiable for this consult";
                $return['error'] 		= '';
                $return['data'] 		= '';
                $this->response($return, REST_Controller::HTTP_BAD_REQUEST); 
            }
            $doctor_id = $doctor->doctor_id;
            $doctor_fcm = $doctor->fcm_key;
            $consult_id = $data['consult_id'];
        }
        $consultActive = $this->patient->csActive($consult_id);
        //echo $this->db->last_query();die;
        if($consultActive)
        {
            $dataQuestion = array(
                "question"=>$data['question'],
                "consult_id"=>$consult_id,
                "consult_for"=>$data['consult_for'],
                "asked_on_date"=>date("Y-m-d H:i:s")
            );
            if(isset($data['family_member_id']))
            {
                $dataQuestion['family_member_id']=$data['family_member_id'];
            }
            
            $this->db->insert("consultation_question",$dataQuestion);
            $question_id = $this->db->insert_id();
            
            $this->db->query("UPDATE `consultation` SET available_question_cnt= (available_question_cnt -1) WHERE id=".$consult_id);
            
            $dataQuestion['patient_id'] = $data['patient_id'];
            $dataQuestion['question_id'] = $question_id;
            $result = $this->firebase->notify($doctor_fcm, 'MyMD', 'Consult Question',  $dataQuestion);
            $return['success'] 		= true;
            $return['message'] 		= "Consult added succesfully.";
            $return['error'] 		= '';
            $return['data'] 		= '';		
            $this->response($return, REST_Controller::HTTP_OK);
        }
        else
        {
            $return['success'] 		= false;
            $return['message'] 		= "Consult not available";
            $return['error'] 		= '';
            $return['data'] 		= '';
            $this->response($return, REST_Controller::HTTP_NOT_IMPLEMENTED); 
        }
    }
    
    public function buyConsultPackage_post()
    {
        $data = json_decode( file_get_contents('php://input'),true);
        $res = new blankClass();
        if(isset($data['patient_id']) && isset($data['package_id']) && isset($data['amount']))
        {
            $arrPackage = $data['package_id'];
            if(!empty($arrPackage)){
            foreach ($arrPackage as $pkgID)
            {
                $packageDetail = $this->patient->packageDetail($pkgID);
                $tmpdate = new DateTime();
                $packageDetail->validity_period.$packageDetail->validity_period_code;
                $tmpdate->add(new DateInterval("P".$packageDetail->validity_period.$packageDetail->validity_period_code));
               
                //print_r($tmpdate);die;
                $expected_expiry_date =  $tmpdate->format('Y-m-d H:i:s');
                $currentDate = date("Y-m-d H:i:s");

                $dataPackage = array(
                    "amount"=>$data['amount'], 
                    "expected_expiry_date"=>$expected_expiry_date, 
                    "modified_date"=>$currentDate, 
                    "no_of_consults"=>$packageDetail->no_of_consults, 
                    "purchase_date"=>$currentDate, 
                    "validity_period"=>$packageDetail->validity_period, 
                    "validity_period_unit"=>$packageDetail->validity_period_unit,
                    "package_id"=>$pkgID, 
                    "patient_id"=>$data['patient_id'],
                    "transection_id"=>$data['transection_id']
                    );
                //print_r($dataPackage);
                $result = $this->patient->addConsultPackage($dataPackage);
                $this->updateExistingConsultPackageExpiery($dataPackage);
            }
        }
            
            if($result)
            {
                $this->response($res, REST_Controller::HTTP_OK);
            }
            else
            {
                $this->response($res, REST_Controller::HTTP_INTERNAL_SERVER_ERROR);
            }
        }
        else
        {
            $this->response($res, REST_Controller::HTTP_BAD_REQUEST);
        }
    }
    
    public function updateExistingConsultPackageExpiery($dataPackage)
    {
        $this->db->where('patient_id',$dataPackage['patient_id']);
        $this->db->where('expected_expiry_date > ',$dataPackage['purchase_date']);
        $this->db->order_by('expected_expiry_date','DESC');
        $this->db->limit(1);
        $query = $this->db->get('patient_consult_package');
        
        if($query->num_rows() > 0)
        {
            $data = $query->row();
            $this->db->where('patient_id',$dataPackage['patient_id']);
            $this->db->where('expected_expiry_date > ',$dataPackage['purchase_date']);
            $this->db->update('patient_consult_package',array('expected_expiry_date'=>$data->expected_expiry_date));
        }
    }
    public function submit_patient_appoinment_post(){
        $postData = json_decode(file_get_contents('php://input'), true);
        if(empty($postData)){
		$postData=$_POST;
        }
        $res = new blankClass();
        if (isset($postData['doctor_id']) && $postData['patient_id'] && $postData['consult_id']) {
          
            $postData = $this->security->xss_clean($postData);
            $this->form_validation->set_data($postData);

            $this->form_validation->set_rules('name', 'Name', 'trim|required');
            $this->form_validation->set_rules('email', 'Email', 'trim|required|valid_email');
            $this->form_validation->set_rules('phone', 'Phone Number', 'trim|required|phone|min_length[5]|max_length[13]');
            $this->form_validation->set_rules('gender', 'Gender', 'trim|required');
            $this->form_validation->set_rules('date', 'Date', 'trim|required');
            $this->form_validation->set_rules('time', 'Time', 'trim|required');
            $this->form_validation->set_rules('remark', 'Remark', 'trim|required');

            $error = array();
            if ($this->form_validation->run() === False) {
                $error = $this->form_validation->error_array();
                $this->response(["error" => $error], REST_Controller::HTTP_BAD_REQUEST);
            }

                $appointmentCreated = 0;
                    $postData['patient_id'] = $postData['patient_id'];
                    $postData['doctor_id'] = $postData['doctor_id'];
                    $postData['consult_id'] = $postData['consult_id'];
                    $postData['name'] = $postData['name'];
                    $postData['email'] = $postData['email'];
                    $postData['phone'] = $postData['phone'];
                    $postData['gender'] = $postData['gender'];
                    $postData['date'] = $postData['date'];
                    $postData['time'] = $postData['time'];
                    $postData['status'] = 1;
                    $appointmentCreated = $this->patient->book_appointment($postData);

                if ($appointmentCreated) {
                    $messageHtml= '<table>';
                 $messageHtml .= '<tr>
                                <td colspan="2" sytle="font-size:26px;">Appointment Details</td>
                            </tr>
                            <tr>
                                <td width="200"><strong>Name :</strong></td>
                                <td>'.$postData['name'].'</td>
                            </tr>
                            <tr>
                                <td><strong>Email :</strong></td>
                                <td>'.$postData['email'].'</td>
                            </tr>
                            <tr>
                                <td><strong>Phone :</strong></td>
                                <td>'.$postData['phone'].'</td>
                            </tr>
                            <tr>
                                <td><strong>Appointment Date & Time :</strong></td>
                                <td>'.$postData['date']." ".$postData['time'].'</td>
                            </tr>';
                    $messageHtml .= '</table>';
                    $mail = new ElasticMail();
                    $mail->SendEmail3($postData['email'], "An Appointment as been scheduled", "", "MyMD", $messageHtml);
                    $return['success'] 		= true;
                    $return['message'] 		= "Appointment booked successfully.";
                    $return['error'] 		= '';
                    $return['data'] 		= '';
                    $this->response($return, REST_Controller::HTTP_CREATED);
                } else {
                    $return['success'] 		= false;
                    $return['message'] 		= "Some thing went wrong.";
                    $return['error'] 		= '';
                    $return['data'] 		= '';
                    $this->response($return, REST_Controller::HTTP_INTERNAL_SERVER_ERROR);
                }
            //}
        } else {
            $return['success'] 		= false;
            $return['message'] 		= "Please fill required field.";
            $return['error'] 		= '';
            $return['data'] 		= '';
            $this->response($return, REST_Controller::HTTP_BAD_REQUEST);
           
        }
    }

    public function book_appointment_post() {
        $postData = json_decode(file_get_contents('php://input'), true);
        if(empty($postData)){
		$postData=$_POST;
        }
        $res = new blankClass();
        if (isset($postData['doctor_id']) && $postData['patient_id'] && $postData['consult_id']) {
          
            $postData = $this->security->xss_clean($postData);
            $this->form_validation->set_data($postData);

            $this->form_validation->set_rules('name', 'Name', 'trim|required');
            $this->form_validation->set_rules('email', 'Email', 'trim|required|valid_email');
            $this->form_validation->set_rules('phone', 'Phone Number', 'trim|required|phone|min_length[5]|max_length[13]');
            $this->form_validation->set_rules('gender', 'Gender', 'trim|required');
            $this->form_validation->set_rules('date', 'Date', 'trim|required');
            $this->form_validation->set_rules('time', 'Time', 'trim|required');
            $this->form_validation->set_rules('remark', 'Remark', 'trim|required');

            $error = array();
            if ($this->form_validation->run() === False) {
                $error = $this->form_validation->error_array();
                $this->response(["error" => $error], REST_Controller::HTTP_BAD_REQUEST);
            }

            // if ($this->patient->userExist($postData['email'], $postData['phone_number'])) {
            //     $return['success'] 		= false;
            //     $return['message'] 		= "User already exist";
            //     $return['error'] 		= '';
            //     $return['data'] 		= '';
            //     $this->response($return, REST_Controller::HTTP_BAD_REQUEST);
               
            // } else {
                

                // $this->load->helper('password');
                // $password = generatePassword();
                // $this->load->library('elasticMail');
                // $mail = new ElasticMail();
                // $mailResponse = $mail->SendEmail($postData['email'], "MyMd Registration", "raghavendra@chawtechsolutions.com", "MyMd", "Your temporary password is " . $password);
                // $postData['password'] = $password;

                $appointmentCreated = 0;

                //if ($mailResponse) {
                    $postData['patient_id'] = $postData['patient_id'];
                    $postData['doctor_id'] = $postData['doctor_id'];
                    $postData['consult_id'] = $postData['consult_id'];
                    $postData['name'] = $postData['name'];
                    $postData['email'] = $postData['email'];
                    $postData['phone'] = $postData['phone'];
                    $postData['gender'] = $postData['gender'];
                    $postData['date'] = $postData['date'];
                    $postData['time'] = $postData['time'];
                    $postData['status'] = 0;
                    $appointmentCreated = $this->patient->book_appointment($postData);
               // }
                 $messageHtml= '<table>';
                 $messageHtml .= '<tr>
                                <td colspan="2" sytle="font-size:26px;">Appointment Details</td>
                            </tr>
                            <tr>
                                <td width="200"><strong>Name :</strong></td>
                                <td>'.$postData['name'].'</td>
                            </tr>
                            <tr>
                                <td><strong>Email :</strong></td>
                                <td>'.$postData['email'].'</td>
                            </tr>
                            <tr>
                                <td><strong>Phone :</strong></td>
                                <td>'.$postData['phone'].'</td>
                            </tr>
                            <tr>
                                <td><strong>Appointment Date & Time :</strong></td>
                                <td>'.$postData['date']." ".$postData['time'].'</td>
                            </tr>';
                    $messageHtml .= '</table>';
                    echo $messageHtml;die;
                    $response = $mail->SendEmail3($postData['email'], "Patient Appointment Details", "", "MyMD", $messageHtml);

                if ($appointmentCreated) {
                    $return['success'] 		= true;
                    $return['message'] 		= "Appointment booked successfully.";
                    $return['error'] 		= '';
                    $return['data'] 		= '';
                    $this->response($return, REST_Controller::HTTP_CREATED);
                } else {
                    $return['success'] 		= false;
                    $return['message'] 		= "Some thing went wrong.";
                    $return['error'] 		= '';
                    $return['data'] 		= '';
                    $this->response($return, REST_Controller::HTTP_INTERNAL_SERVER_ERROR);
                }
            //}
        } else {
            $return['success'] 		= false;
            $return['message'] 		= "Please fill required field.";
            $return['error'] 		= '';
            $return['data'] 		= '';
            $this->response($return, REST_Controller::HTTP_BAD_REQUEST);
           
        }
    }
    public function appoinment_history_get()
    {
       $id = $this->get('id');
        
        if($id === NULL)
        {
            $this->response(NULL, REST_Controller::HTTP_BAD_REQUEST); 
        }
        else
        {
            $result =$this->patient->getAppoinmentHistory($id);
            
            if(empty($result))
            {
                
                $this->response(["data"=>$result], REST_Controller::HTTP_NO_CONTENT);
            }
            else
            {
                $this->response(["data"=>$result], REST_Controller::HTTP_OK);
            }
            
        }
             
    }

   
}


