<?php

class Patient_model extends CI_Model
{
    public function updatePatientFCM($userID,$data)
    {
        $this->db->where('id',$userID);
        return $this->db->update('patient',$data);
    }
    
    public function add($data)
    {
        $data['password'] = md5($data['password']);
        $this->db->insert('user',$data);
        $user_id =  $this->db->insert_id();
        $patient = array();
        $patient['created_date'] = $data['created_date'];
        $patient['first_name'] = $data['first_name'];
        $patient['last_name'] = $data['last_name'];
        $patient['phone_number'] = $data['phone_number'];
        //$patient['fcm_key'] = $data['fcm_key'];
        //$patient['device'] = $data['device'];
        $patient['user_id'] = $user_id;
        $this->db->insert('patient',$patient);
        return $user_id;
    }
    
    public function matchPassword($id,$Password)
    {
        $this->db->select('u.*');
        $this->db->from('user u');
        $this->db->join('patient p','p.user_id = u.id','LEFT');
        $this->db->where('p.id',$id);
        $this->db->where('u.password',$Password);
        $query = $this->db->get();
        if($query->num_rows() == 1)
        {
            return $query->row()->id;
        }
        else 
        {
            return false;
        }
        
    }
    
    public function resetPassword($userID,$password)
    {
        $this->db->where('id',$userID);
        return $this->db->update('user',array('password'=> md5($password)));
    }
    
    public function updatePatient($userID,$data)
    {
        $this->db->where('id',$userID);
        return $this->db->update('user',$data);
    }
    
    public function updatePatientProfile($userID,$data)
    {
        $this->db->where('id',$userID);
        return $this->db->update('patient',$data);
    }
    
    public function getConsultDoctor($id)
    {
        $this->db->select('c.doctor_id,d.fcm_key');
        $this->db->from("consultation c");
        $this->db->join("doctor d","c.doctor_id = d.id","LEFT");
        $this->db->where('c.id',$id);
        $query= $this->db->get();
        return $query->row();
    }
    
    public function csActive($id)
    {
        $currentDate = date("Y-m-d H:i:s");
        $this->db->where('id',$id);
        $this->db->where('status != 2');
        $this->db->where("(end_date >='$currentDate' OR end_date IS NULL) ");
        $this->db->where('available_question_cnt > ',0);
        $query = $this->db->get("consultation");
        
        if($query->num_rows() > 0)
        {
            return true;
        }
        else
        {
            return false;
        }
    }
    
    public function closeConsult($patient_id,$consult_id)
    {
        $this->db->where('patient_id',$patient_id);
        $this->db->where('id',$consult_id);
        return $this->db->update('consultation',array('status'=>2));
    }

    public function getDoctorDetails($doctor_id)
    {
        $this->db->select("`id`, `credential`, `practice_address1`, `first_name`, `last_name`, `middle_name`,  `practice_cell`, `practice_city`, `practice_country_code`, `practice_fax`, `practice_postal_code`, `practice_state`, `practice_phone`, `practice_mail_address`, `practice_postal_code_latitude`, `practice_postal_code_longitude`,`whatsapp_number`,`whatsapp_country_code`");
        $this->db->where('id',$doctor_id);
        $query = $this->db->get('doctor');
        if($query->num_rows() == 1)
        {
            return $query->row();
        }
        else
        {
            return false;
        }
    }

    public function getDefaultDoctor()
    {
        $unitMultiple = 3959;
        if($unitType == 'km')
        {
            $unitMultiple = 6371;
        }
        elseif($unitType == 'mi')
        {
            $unitMultiple = 3959;
        }
        
        $this->db->select('d.id, ROUND( ( '.$unitMultiple.' * acos( cos( radians('.$lat.') ) * cos( radians( d.practice_postal_code_latitude ) ) * cos( radians( d.practice_postal_code_longitude ) - radians('.$long.') ) + sin( radians('.$lat.') ) * sin( radians( d.practice_postal_code_latitude ) ) ) ), 2) AS distance,fcm_key');
        $this->db->from("doctor d");
        $this->db->where("d.is_default_doctor",1);
        $this->db->order_by('distance','ASC');
        $this->db->limit(1);
        $query= $this->db->get();
        
        return $query->row();
    }
    
    public function getNearestDoctor($lat,$long,$unitType='')
    {
        $unitMultiple = 3959;
        if($unitType == 'km')
        {
            $unitMultiple = 6371;
        }
        elseif($unitType == 'mi')
        {
            $unitMultiple = 3959;
        }
        
        $this->db->select('d.id, ROUND( ( '.$unitMultiple.' * acos( cos( radians('.$lat.') ) * cos( radians( d.practice_postal_code_latitude ) ) * cos( radians( d.practice_postal_code_longitude ) - radians('.$long.') ) + sin( radians('.$lat.') ) * sin( radians( d.practice_postal_code_latitude ) ) ) ), 2) AS distance,fcm_key');
        $this->db->from("doctor d");
        $this->db->order_by('distance','ASC');
        $this->db->limit(1);
        $query= $this->db->get();
        
        return $query->row();
    }
    
    public function getDoctorFCM($id)
    {
        $this->db->select('id, fcm_key');
        $this->db->from("doctor");
        $this->db->where('id',$id);
        $query= $this->db->get();
        return $query->result();
    }
    
    public function getDetail($id)
    {
        $this->db->select("`id`, `address1`, `address2`, `city`, `country`, `postal_code`, `province`,`postal_code_latitude`, `postal_code_longitude`,gps_latitude,gps_longitude, DATE_FORMAT(`birth_date`,'%Y-%m-%d') as birth_date,  `first_name`, `last_name`, allergies,medications,`phone_number`,user_id");
        $this->db->where('id',$id);
        $query = $this->db->get('patient');
        //echo $this->db->last_query();die;
        if($query->num_rows() == 1)
        {
            $dataProfile = $query->row();
            
            $this->db->where('id',$dataProfile->user_id);
            $query2 = $this->db->get('user');
            $dataUser = $query2->row();
            $dataProfile->username = $dataUser->username;
            unset($dataProfile->user_id);
            return $dataProfile;
        }
        else
        {
            return false;
        }
    }
    
    public function userExist($email,$mobile)
    {
        if($email)
        {
            $this->db->where('email',$email);
        }
        
        if($email && $mobile)
        {
            $this->db->or_where('phone_number',$mobile);
        }
        elseif(!$email && $mobile)
        {
            $this->db->where('phone_number',$mobile);
        }
        $query = $this->db->get('user');
        if($query->num_rows()>0)
        {
            $dataUser = $query->row();
            return $dataUser->id;
        }
        else
        {
            return false;
        }
        
    }
       
    public function validate($email,$password)
    {
        $this->db->select("p.id,u.email, p.first_name, p.last_name, p.phone_number,p.address1, DATE_FORMAT( p.birth_date,'%Y-%m-%d') as birth_date,p.user_id");
        $this->db->from('user u');
        $this->db->join('patient p','u.id = p.user_id');
        $this->db->where('u.email',$email);
        $this->db->where('u.user_type',1);
        $this->db->where('u.password', md5($password));
        $query = $this->db->get();
        //echo $this->db->last_query()."yogendra";
        //echo $query->num_rows();
        if($query->num_rows() == 1)
        {
            return $query->row();
        }
        else
        {
            return false;
        }
    }
    
    
    public function getFamilyList($id)
    {
        $this->db->select("`id` as member_id, `allergies`,  DATE_FORMAT(`birth_date`,'%Y-%m-%d') as birth_date,  `first_name`, `last_name`, `medications`, `relationship`");
        $this->db->from('patient_family_member');
        $this->db->where('patient_id',$id);
        $query = $this->db->get();
        
        if($query->num_rows() > 0)
        {
            return $query->result();
        }
        else
        {
            return array();
        }
    }
    
    public function addFamily($data)
    {
        $data['patient_id'] = $data['id'];
        $data['created_date'] = date("Y-m-d H:i:s");
        unset($data['id']);
        return $this->db->insert('patient_family_member',$data);
    }
    
    public function updateFamily($data)
    {
        $data['patient_id'] = $data['id'];
        unset($data['id']);
        
        $member_id = $data['member_id'];
        unset($data['member_id']);
        
        $data['modified_date'] = date("Y-m-d H:i:s");
        
        $this->db->where('id',$member_id);
        return $this->db->update('patient_family_member',$data);
    }
    
    public function deleteFamily($id)
    {      
        $this->db->where('id',$id);
        return $this->db->delete('patient_family_member');
    }
    
    public function packageList()
    {
        $this->db->select('p.*,u.name as validity_period_name');
        $this->db->from('consult_package p');
        $this->db->join('validity_unit u','p.validity_period_unit = u.id');
        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            return $query->result();
        }
        else
        {
            return false;
        }
    }
    
    public function getAvailableConsult($id)
    {
        $this->db->select("sum( no_of_consults) as available_consult");
        $this->db->from("patient_consult_package");
        $this->db->where('patient_id',$id);
        //$this->db->where('c.available_question_cnt',0);
        $this->db->where('expected_expiry_date >= ',date("Y-m-d"));
        $query = $this->db->get();
        //echo $this->db->last_query();
        return $query->row()->available_consult;
    }
    
    public function getConsultExpiery($id)
    {
        $this->db->select("max( expected_expiry_date) expected_expiry_date");
        $this->db->from("patient_consult_package");
        $this->db->where('patient_id',$id);
        //$this->db->where('c.available_question_cnt',0);
        $query = $this->db->get();
        //echo $this->db->last_query();
        return $query->row()->expected_expiry_date;
    }
    
    public function getUsedConsult($id)
    {
        $this->db->select("min( purchase_date) as start_date");
        $this->db->from("patient_consult_package");
        $this->db->where('patient_id',$id);
        //$this->db->where('c.available_question_cnt',0);
        $this->db->where('expected_expiry_date >= ',date("Y-m-d"));
        $this->db->group_by('patient_id');
        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            $startDate = $query->row()->start_date;
            $this->db->select("count(id) as total_used");
            $this->db->from("consultation");
            $this->db->where('patient_id',$id);
            $this->db->where("start_date > ",$startDate);
            $this->db->group_by('patient_id');
            $query = $this->db->get();
            if($query->num_rows() > 0)
            {
                return $query->row()->total_used;
            }
            else
            {
                return 0;
            }
        }
        else
        {
            return 0;
        }
        //
        
    }
    
    public function getActiveConsult($id)
    {
        $tmpdate = new DateTime();
        $tmpdate->sub(new DateInterval("PT3H"));
        $expected_expiry_date =  $tmpdate->format('Y-m-d H:i:s');
        
        $this->db->select("c.id, c.available_question_cnt, c.consult_code, c.end_date,  c.start_date, c.status, c.doctor_id, c.patient_id,d.first_name,d.last_name");
        $this->db->from("consultation c");
        $this->db->join('doctor d','c.doctor_id = d.id',"LEFT");
        //$this->db->where('c.available_question_cnt > 0');
        $this->db->where('c.patient_id',$id);
        $this->db->where('status != 2');
        $this->db->where("(end_date >= '$expected_expiry_date' OR end_date is NULL)");
        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            return $query->result();
        }
        else
        {
            return array();
        }
    }
    
    public function getInActiveConsult($id)
    {
        $tmpdate = new DateTime();
        $tmpdate->sub(new DateInterval("PT3H"));
        $expected_expiry_date =  $tmpdate->format('Y-m-d H:i:s');
        
        $this->db->select("c.id, c.available_question_cnt, c.consult_code, c.end_date,  c.start_date, c.status, c.doctor_id, c.patient_id,d.first_name,d.last_name");
        $this->db->from("consultation c");
        $this->db->join('doctor d','c.doctor_id = d.id');
        $this->db->where('c.patient_id',$id);
        $this->db->or_where("((c.available_question_cnt=0 OR status = 2) AND c.patient_id = $id)");
        $this->db->where('start_date < ',$expected_expiry_date);
        $query = $this->db->get();
        //echo $this->db->last_query();die; 
        if($query->num_rows() > 0)
        {
            return $query->result();
        }
        else
        {
            return array();
        }
    }
    
    public function getConsultQuestion($id)
    {
        $this->db->select("*");
        $this->db->from("consultation_question");
        $this->db->where('consult_id',$id);
        
        $query = $this->db->get();
         
        if($query->num_rows() > 0)
        {
            return $query->result();
        }
        else
        {
            return false;
        }
    }
    
    public function packageDetail($id)
    {
        $this->db->select('p.*,u.name as validity_period_name,u.code as validity_period_code');
        $this->db->from('consult_package p');
        $this->db->join('validity_unit u','p.validity_period_unit = u.id');
        $this->db->where('p.id',$id);
        $query = $this->db->get();
        //echo $this->db->last_query();die;
        if($query->num_rows() > 0)
        {
            return $query->row();
        }
        else
        {
            return false;
        }
    }
    
    public function addConsultPackage($data)
    {
        return $this->db->insert('patient_consult_package',$data);
    }

    public function book_appointment($data)
    {
        $this->db->insert('book_appointment_history',$data);
        return $this->db->insert_id();
    }

    public function getAppoinmentHistory($id)
    {
        $this->db->select("b.id, b.name,b.email,b.phone,b.gender,b.date,b.time,c.consult_code, c.end_date,  c.start_date,d.first_name,d.last_name");
        $this->db->from("book_appointment_history b");
        $this->db->join('consultation c','b.consult_id = c.id');
        $this->db->join('doctor d','b.doctor_id = d.id');
        $this->db->where('b.patient_id',$id);
        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            return $query->result();
        }
        else
        {
            return array();
        }
    }
}
