<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Doctor extends CI_Controller {

    public function __construct() {
        parent::__construct();
        if ($this->session->userdata('is_logged_in') != true || ($this->session->userdata('user_role') != 2 && $this->session->userdata('user_role') != 3)) {
            redirect('login');
        }
        $this->load->model('user_model','user');
    }

    public function index() {

        $page = "Doctor";
        $data['title'] = ucfirst($page);
        $userdata = $this->session->userdata('user_data');
        $data['user_name'] = $userdata->first_name;
        $data['menu'] = "dashboard";

        $this->load->view('index', $data);
    }

    //Dashboard
    public function dashboard() {
        $userdata = $this->session->userdata('user_data');
        $data['user_name'] = $userdata->first_name;
        $this->load->view('dashboard',$data);
    }
    
    public function profile() {
        $userData = $this->session->userdata('user_data');
        
        $data['DoctorID'] = $this->user->getDoctorID($userData->id);
        $this->load->view('doctor-detail',$data); 
    }
    
    public function consultation() {
        $userData = $this->session->userdata('user_data');
        
        $data['DoctorID'] = $this->user->getDoctorID($userData->id);
        $this->load->view('consultation',$data); 
    }
    
    public function getDoctor($id)
    {
        $id = str_replace('_', '-', $id);
        $data = $this->user->getDoctor($id);
        echo json_encode($data);
    }
    
    public function getDoctorNPI($id)
    {
        $id = str_replace('_', '-', $id);
        $data = $this->user->getDoctorNPI($id);
        echo json_encode($data);
    }
    
    public function getDoctorLicence($id)
    {
        $id = str_replace('_', '-', $id);
        $data = $this->user->getDoctorLicence($id);
        echo json_encode($data);
    }
    
    public function getState()
    {
        $query = $this->db->get('state');
        echo json_encode($query->result());
    }
    
    
    public function updateDoctor()
    {
        $data = json_decode( file_get_contents('php://input'),true);
        //print_r($data);die;
        $response = array("success"=>'',"error"=>'',"title"=>'',"message"=>'');
        
        if($this->user->updateDoctor($data))
        {
            $response['success']=1;
            $response['title']= "Success";
            $response['message']= "Updated successfuly.";
        }
        else
        {
            $response['error']=1;
            $response['title']= "Error";
            $response['message']= "Some error happen!";
        }
        echo json_encode($response);
    }
    
    public function updateDoctorLicence()
    {
        $data = json_decode( file_get_contents('php://input'),true);
        //print_r($data);die;
        $response = array("success"=>'',"error"=>'',"title"=>'',"message"=>'');
        
        if($this->user->updateDoctorLicence($data))
        {
            $response['success']=1;
            $response['title']= "Success";
            $response['message']= "Licence Updated successfuly.";
        }
        else
        {
            $response['error']=1;
            $response['title']= "Error";
            $response['message']= "Some error happen!";
        }
        echo json_encode($response);
    }
    
    public function updatePassword()
    {
        $data = json_decode( file_get_contents('php://input'),true);
        $response = array("success"=>'',"error"=>'',"title"=>'',"message"=>'');
        
        $data = $this->security->xss_clean($data);
        $this->form_validation->set_data($data);
        $this->form_validation->set_rules('oldpassword', 'Old Password', 'trim|required');
        $this->form_validation->set_rules('newpassword', 'New Password', 'trim|required');
        $this->form_validation->set_rules('confirmpassword', 'Confirm Password', 'trim|required|matches[newpassword]');
        
        $error = array();
        if ($this->form_validation->run() === False) {
            $error = validation_errors();
            $response['error']=1;
            $response['title']= "Error";
            $response['message']= $error;
        }
        else
        {
            $userData = $this->session->userdata('user_data');
            if($this->user->matchPassword($userData->id, md5($data['oldpassword'])))
            {
                if($this->user->updatePassword($userData->id,md5($data['newpassword'])))
                {
                    $response['success']=1;
                    $response['title']= "Success";
                    $response['message']= "Password updated successfuly.";
                }
                else
                {
                    $response['error']=1;
                    $response['title']= "Error";
                    $response['message']= "Some error happen!";
                }
            }
            else
            {
                $response['error']=1;
                $response['title']= "Error";
                $response['message']= "Old password did not match.";
            }
        }
        echo json_encode($response);
    } 
    
    public function getDoctorTaxonomy($id)
    {
        $id = str_replace('_', '-', $id);
        $data = $this->user->getDoctorTaxonomy($id);
        echo json_encode($data);
    }
    
    public function getTaxonomy()
    {
        $query = $this->db->get('taxonomy');
        echo json_encode($query->result());
    }
    
    public function deleteTaxonomy()
    {
        $data = json_decode( file_get_contents('php://input'),true);
        
        $response = array("success"=>'',"error"=>'',"title"=>'',"message"=>'');
        
                   
        if($this->user->deleteTaxonomy($data))
        {
            $response['success']=1;
            $response['title']= "Success";
            $response['message']= "Taxonomy deleted successfuly.";
        }
        else
        {
            $response['error']=1;
            $response['title']= "Error";
            $response['message']= "Some error happen!";
        }
        
        echo json_encode($response);
    }
    
    public function addTaxonomy()
    {
        $data = json_decode( file_get_contents('php://input'),true);
        //print_r($data);die;
        $response = array("success"=>'',"error"=>'',"title"=>'',"message"=>'');
        
        $this->db->where($data);
        $query = $this->db->get('doctor_taxonomy');
        
        if($query->num_rows() > 0)
        {
            $response['error']=1;
            $response['title']= "Error";
            $response['message']= "Already exist!";
        }
        else
        {            
            if($this->user->addTaxonomy($data))
            {
                $response['success']=1;
                $response['title']= "Success";
                $response['message']= "Taxonomy added successfuly.";
            }
            else
            {
                $response['error']=1;
                $response['title']= "Error";
                $response['message']= "Some error happen!";
            }
        }
        echo json_encode($response);
    }
    
    public function getNPI($npi_number)
    {
        if(isset($npi_number))
        {
            $result = $this->checkNPI($npi_number);
            $response = array("success"=>'',"error"=>'',"title"=>'',"message"=>'');
            if(isset($result->results))
            {
                if($result->result_count == 1)
                {
                    if($result->results[0]->enumeration_type == 'NPI-1')
                    {
                        $res = $result->results[0];
                        $response['success']=1;
                        $response['title']= "Success";
                        $response['message']= "NPI details found, please verify.";
                        $response['NPI']= $res;                     
                    }
                    else
                    {
                        $response['error']=1;
                        $response['title']= "Error";
                        $response['message']= "You can not add NPI-2.";
                    }
                }
                else
                {
                    $response['error']=1;
                    $response['title']= "Error";
                    $response['message']= "No data found.";
                }
            }
            else
            {
                $response['error']=1;
                $response['title']= "Error";
                $response['message']= "NPI Number is wrong, Please check your NPI number.";
            }
        }
        
        echo json_encode($response);
    }
    
    public function updateNPI()
    {
        $data = json_decode( file_get_contents('php://input'));
        
        $response = array("success"=>'',"error"=>'',"title"=>'',"message"=>'');
        
        $userData = $this->session->userdata('user_data');
        
        $DoctorID = $this->user->getDoctorID($userData->id);
        
        if($this->user->updateNPI($DoctorID,$data))
        {
            $response['success']=1;
            $response['title']= "Success";
            $response['message']= "NPI Updated successfuly.";
        }
        else
        {
            $response['error']=1;
            $response['title']= "Error";
            $response['message']= "Some error happen!";
        }
        echo json_encode($response);
    }
    
    private function checkNPI($npi_number)
    {
        $url = "https://npiregistry.cms.hhs.gov/api/?number=".$npi_number.'&version=2.1';
        $result = file_get_contents($url);
        $data = json_decode($result);
        return $data;
    }
}
