<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class User_model extends CI_Model {
    
    public function getDoctor($id)
    {
        $this->db->select("d.*,u.email,");
        $this->db->from('doctor d');
        $this->db->join('user u','d.user_id = u.id','LEFT');
        $this->db->where('d.id',$id);
        $query = $this->db->get();
        if($query->num_rows() ==1)
        {
            return $query->row();
        }
        else 
        {
            false;
        }
    }
    
    public function updateNPI($userID,$data)
    {
        //print_r($data);die;
        if(isset($data->taxonomies))
        {
            if(is_array($data->taxonomies))
            {
                $this->db->where('doctor_id',$userID);
                    $this->db->delete('doctor_npi_taxonomy'); 
                foreach ($data->taxonomies as $taxonomy)
                {
                    $taxonomy->doctor_id = $userID;
                    $this->db->insert('doctor_npi_taxonomy',$taxonomy);
                }
            }
        }
        
        if(isset($data->addresses))
        {
            if(is_array($data->addresses))
            {
                $this->db->where('doctor_id',$userID);
                $this->db->delete('doctor_npi_address');     
                foreach ($data->addresses as $addresses)
                {
                    $addresses->doctor_id = $userID;
                    $this->db->insert('doctor_npi_address',$addresses);
                }
            }
        }
        
        if(isset($data->basic))
        {            
            $basic = $data->basic;
            $this->db->where('doctor_id',$userID);
            $this->db->delete('doctor_npi_details');                    
            $basic->doctor_id = $userID;
            return $this->db->insert('doctor_npi_details',$basic);
        }
    }
    
    public function getDoctorID($id)
    {
        $this->db->select("d.id");
        $this->db->from('doctor d');
        $this->db->where('d.user_id',$id);
        $query = $this->db->get();
        
        if($query->num_rows() ==1)
        {
            return $query->row()->id;
        }
        else 
        {
            false;
        }
    }
    
    public function getDoctorNPI($id)
    {
        $data = array('taxonomy'=>false,'address'=>false,'basic'=>false);
        
        $this->db->where('doctor_id',$id);
        $queryBasic = $this->db->get('doctor_npi_details');
        if($queryBasic->num_rows() > 0)
        {
            $data['basic'] = $queryBasic->row();
        }
        
        $this->db->where('doctor_id',$id);
        $queryAddress = $this->db->get('doctor_npi_address');
        if($queryAddress->num_rows() > 0)
        {
            $data['address'] = $queryAddress->result();
        }
        
        $this->db->where('doctor_id',$id);
        $queryTaxonomy = $this->db->get('doctor_npi_taxonomy');
        if($queryTaxonomy->num_rows() > 0)
        {
            $data['taxonomy'] = $queryTaxonomy->result();
        }
        
        return $data;
    }
    
    public function getDoctorLicence($id)
    {
        $this->db->select(" Date_Format(l.expiry_date,'%Y-%m-%d') As expiry_date, l.license_number, l.doctor_id, l.state_id,s.name as state_name, s.code as state_code");
        $this->db->from('doctor_license l');
        $this->db->join('state s','l.state_id = s.id','LEFT');
        $this->db->where('l.doctor_id',$id);
        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            return $query->row();
        }
        else
        {
            return false;
        }
    }
    
    public function getDoctorTaxonomy($id)
    {
        $this->db->select("dt.*,t.code,t.name");
        $this->db->from('doctor_taxonomy dt');
        $this->db->join('taxonomy t','dt.taxonomy_id = t.id','LEFT');
        $this->db->where('dt.doctor_id',$id);
        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            return $query->result();
        }
        else
        {
            return false;
        }
    }
    
    public function addTaxonomy($data)
    {
        return $this->db->insert('doctor_taxonomy',$data);
    }
    
    public function deleteTaxonomy($data)
    {
        $this->db->where($data);
        return $this->db->delete('doctor_taxonomy');
    }


    public function updateDoctor($data)
    {
        $this->db->where('id',$data['id']);
        unset($data['id']);
        return $this->db->update('doctor',$data);
    }
    
    public function updateDoctorLicence($data)
    {
        $this->db->where('doctor_id',$data['doctor_id']);
        $query = $this->db->get('doctor_license');
        if($query->num_rows() ==1)
        {
            $this->db->where('doctor_id',$data['doctor_id']);
            unset($data['doctor_id']);
            return $this->db->update('doctor_license',$data);
        }
        else
        {
            return $this->db->insert('doctor_license',$data);
        }
    }
    
    public function matchPassword($id,$Password)
    {
        $this->db->select('u.*');
        $this->db->from('user u');
        $this->db->where('u.id',$id);
        $this->db->where('u.password',$Password);
        $query = $this->db->get();
        //echo $this->db->last_query();die;
        if($query->num_rows() == 1)
        {
            return true;
        }
        else 
        {
            return false;
        }
        
    }
    
    public function updatePassword($id,$password)
    {
        $this->db->where('id',$id);
        return $this->db->update('user',array('password'=>$password));
    }
}

/* End of file welcome.php */
/* Location: ./application/controllers/welcome.php */