'use strict';

//Controllers
function HomeCtrl($scope, $http) 
{
    
}

function ConsultationCtrl($scope, $http,$timeout) 
{
    $scope.Consult;
    $scope.ConsultCode;
    $scope.ConsultQuestion;
    $scope.getConsultation = function(){
        $http.get(BASE_URL+"api/doctor/consults/"+$scope.DoctorID,{headers: {'X-API-KEY': 'e10adc3949ba59abbe56e057f20f883e'}}).then(function(response) {
            $scope.Consult = response.data.data;
        });
    }
    
    $scope.getConsultQuestion = function(ob){
        $scope.ConsultCode = ob.consult_code;
        $http.get(BASE_URL+"api/doctor/consultQuestion/"+ob.id,{headers: {'X-API-KEY': 'e10adc3949ba59abbe56e057f20f883e'}}).then(function(response) {
            $scope.ConsultQuestion = response.data.data;
            $("#modalQuestionView").modal("show");
        });
    }
    
    $timeout(function () {
            $scope.getConsultation();            
    }, 1000);
    
}

function ProfileCtrl($scope, $http,$timeout)
{
    $scope.Doctor;
    $scope.DoctorNPI;
    $scope.newNPI;
    $scope.DoctorLicence=false;
    $scope.StateList;
    $scope.eDoctor;
    $scope.DoctorTaxonomy;
    $scope.Taxonomy;
    
    $timeout(function () {
            $scope.getDoctorDetail();
            $scope.getDoctorNPIDetail();
            $scope.getDoctorLicence();
            $scope.getDoctorTaxonomy();
            $scope.getTaxonomy();
            $scope.getState();
            
    }, 1000);
    //
    $("#BirthDate").datepicker({format: "yyyy-mm-dd"}).on('changeDate', function(ev){
            
            $scope.BirthDate = $("#BirthDate").val();
            $('#BirthDate').datepicker('hide');
        }); 
    
    $("#licenceExpiary").datepicker({format: "yyyy-mm-dd"}).on('changeDate', function(ev){
            
            $scope.DoctorLicence.expiry_date = $("#licenceExpiary").val();
            $('#licenceExpiary').datepicker('hide');
        });
        
    $("#licenceExp").datepicker({format: "yyyy-mm-dd"}).on('changeDate', function(ev){
            
            $scope.expiry_date = $("#licenceExp").val();
            $('#licenceExp').datepicker('hide');
        });
        
    
    $scope.getDoctorDetail = function(){
        
            $http.get(BASE_URL+"doctor/getDoctor/"+$scope.DoctorID).then(function(response) {
                        $scope.Doctor = response.data;
                        $scope.eDoctor = response.data;
                    });
    };
    
    $scope.getNPI = function(){
        
            $http.get(BASE_URL+"doctor/getNPI/"+$scope.NPINumber).then(function(response) {
                        var result = response.data;
                        var Gritter = function () {
                            $.gritter.add({
                                title: result.title,
                                text: result.message
                            });
                            return false;
                        }();
                        if(result.success == 1)
                        {
                            $("#btnGetNPI").addClass('hidden');
                            $("#btnSaveNPI").removeClass('hidden');
                        }
                        $scope.newNPI = response.data.NPI;
                    });
    };
    
    
            
    $scope.getState = function(){
        
            $http.get(BASE_URL+"doctor/getState").then(function(response) {
                        $scope.StateList = response.data;
                    });
            };        
            
    $scope.getDoctorNPIDetail = function(){        
            $http.get(BASE_URL+"doctor/getDoctorNPI/"+$scope.DoctorID).then(function(response) {
                        $scope.DoctorNPI = response.data;
                    });            
    }; 
    
    $scope.getDoctorTaxonomy = function(){        
            $http.get(BASE_URL+"doctor/getDoctorTaxonomy/"+$scope.DoctorID).then(function(response) {
                        $scope.DoctorTaxonomy = response.data;
                    });            
    }; 
    
    $scope.getTaxonomy = function(){        
            $http.get(BASE_URL+"doctor/getTaxonomy").then(function(response) {
                        $scope.Taxonomy = response.data;
                    });            
    }; 
    
    $scope.addTaxonomy = function(){
        var formData = {
            'doctor_id': $scope.DoctorID, 
            'taxonomy_id': $scope.aTaxonomy
         };
        //console.log(formData);
        $http.post('doctor/addTaxonomy', formData).then(function (response) {
            var result  = response.data;
            if(result.message != '')
            {
                var Gritter = function () {
                    $.gritter.add({
                        title: result.title,
                        text: result.message
                    });
                    return false;
                }();
                $scope.getDoctorTaxonomy();
            }
            
            $(".modal").modal('hide');
        });
    };
    
    $scope.deleteTaxonomy = function(id){
        if(confirm('Do you want to delete this taxonomy?'))
        {
            var formData = {
                'doctor_id': $scope.DoctorID, 
                'taxonomy_id': id
             };
            $http.post('doctor/deleteTaxonomy', formData).then(function (response) {
                var result  = response.data;
                if(result.message != '')
                {
                    var Gritter = function () {
                        $.gritter.add({
                            title: result.title,
                            text: result.message
                        });
                        return false;
                    }();
                    $scope.getDoctorTaxonomy();
                }

                $(".modal").modal('hide');
            });
        }
    };
    
    $scope.getDoctorLicence = function(){        
            $http.get(BASE_URL+"doctor/getDoctorLicence/"+$scope.DoctorID).then(function(response) {
                        $scope.DoctorLicence = response.data;
                    });            
    }; 
    
    $scope.edit = function(){
        $("#modalEdit").modal('show');
    }; 
    
    $scope.editMailingAddress = function(){
        $("#modalEditMailingAddress").modal('show');
    }; 
    
    $scope.editLicence = function(){
        $("#modalEditLicance").modal('show');
    }; 
    
    $scope.addLicence = function(){
        $("#modalAddLicance").modal('show');
    }; 
    
    $scope.saveLicence = function(){
        
        var formData = {
            'license_number': $scope.license_number, 
            'state_id': $scope.state_id, 
            'expiry_date': $scope.expiry_date, 
            'doctor_id': $scope.DoctorID
        };
        //console.log(formData);
        $http.post('doctor/updateDoctorLicence', formData).then(function (response) {
            var result  = response.data;
            if(result.message != '')
            {
                var Gritter = function () {
                    $.gritter.add({
                        title: result.title,
                        text: result.message
                    });
                    return false;
                }();
                $scope.getDoctorLicence();
            }
            
            $(".modal").modal('hide');
        });
    };
    
    $scope.update = function(){
         var formData = {
            'practice_mail_address': $scope.eDoctor.practice_mail_address, 
            'practice_cell': $scope.eDoctor.practice_cell, 
            'practice_fax': $scope.eDoctor.practice_fax, 
            'practice_phone': $scope.eDoctor.practice_phone, 
            'id': $scope.DoctorID
        };

        $http.post('doctor/updateDoctor', formData).then(function (response) {
            var result  = response.data;
            if(result.message != '')
            {
                var Gritter = function () {
                    $.gritter.add({
                        title: result.title,
                        text: result.message
                    });
                    return false;
                }();
                $scope.getDoctorDetail();
            }
            
            $(".modal").modal('hide');
        });
        
    };
    
    $scope.updateMailingAddress = function(){
         var formData = {
            'mailing_city': $scope.eDoctor.mailing_city, 
            'mailing_state': $scope.eDoctor.mailing_state, 
            'mailing_postal_code': $scope.eDoctor.mailing_postal_code, 
            'mailing_phone': $scope.eDoctor.mailing_phone,
            'mailing_fax': $scope.eDoctor.mailing_fax,
            'id': $scope.DoctorID
        };

        $http.post('doctor/updateDoctor', formData).then(function (response) {
            var result  = response.data;
            if(result.message != '')
            {
                var Gritter = function () {
                    $.gritter.add({
                        title: result.title,
                        text: result.message
                    });
                    return false;
                }();
                $scope.getDoctorDetail();
            }
            
            $(".modal").modal('hide');
        });
        
    };
    
    $scope.updateDoctorLicence = function(){
         var formData = {
            'license_number': $scope.DoctorLicence.license_number, 
            'state_id': $scope.DoctorLicence.state_id, 
            'expiry_date': $scope.DoctorLicence.expiry_date, 
            'doctor_id': $scope.DoctorID
        };
        //console.log(formData);
        $http.post('doctor/updateDoctorLicence', formData).then(function (response) {
            var result  = response.data;
            if(result.message != '')
            {
                var Gritter = function () {
                    $.gritter.add({
                        title: result.title,
                        text: result.message
                    });
                    return false;
                }();
                $scope.getDoctorLicence();
            }
            
            $(".modal").modal('hide');
        });
        
    };
    
    $scope.saveNPI = function(){
        
        //console.log(formData);
        $http.post('doctor/updateNPI', $scope.newNPI).then(function (response) {
            var result  = response.data;
            if(result.message != '')
            {
                var Gritter = function () {
                    $.gritter.add({
                        title: result.title,
                        text: result.message
                    });
                    return false;
                }();
                $scope.getDoctorNPIDetail();
                if(result.success == 1)
                {
                    $("#btnGetNPI").removeClass('hidden');
                    $("#btnSaveNPI").addClass('hidden');
                    $scope.newNPI = false;
                }
                
            }
            
            $(".modal").modal('hide');
        });
        
    };
    
} 

function UpdatePasswordCtrl($scope, $http) 
{
    $scope.updatePassword = function (){
        if(confirm('Do you want to update password?'))
        {
            var formData = {
                         newpassword:$scope.newpassword,
                         confirmpassword:$scope.confirmpassword,
                         oldpassword:$scope.oldpassword
                     };
            $http.post('doctor/updatePassword', formData).then(function (response) {
                        var result  = response.data;
                        if(result.message != '')
                        {
                            var Gritter = function () {
                                $.gritter.add({
                                    title: result.title,
                                    text: result.message
                                });
                                return false;
                            }();
                            if(result.success == 1)
                            {
                                $(".modal").modal('hide');
                                $scope.newpassword = '';
                                $scope.confirmpassword = '';
                                $scope.oldpassword = '';
                            }
                        }

                        
                    });
        }
    };
}



