<?php

defined('BASEPATH') OR exit('No direct script access allowed');


require APPPATH . '/libraries/REST_Controller.php';

class DAuth extends REST_Controller {

    function __construct() {
        parent::__construct();
        $this->load->model('doctor_model', 'doctor');
        $this->load->library('form_validation');
        $this->load->library("security");
    }

    public function index_post() {
        $postData = json_decode(file_get_contents('php://input'), true);
        $res = new blankClass();
        if (isset($postData['email']) && $postData['first_name'] && $postData['last_name'] && isset($postData['phone_number']) && isset($postData['fcm_key']) && isset($postData['device'])) {
            $postData = $this->security->xss_clean($postData);
            $this->form_validation->set_data($postData);

            $this->form_validation->set_rules('email', 'Email', 'trim|required|valid_email');
            $this->form_validation->set_rules('first_name', 'First Name', 'trim|required');
            $this->form_validation->set_rules('last_name', 'Last Name', 'trim|required');
            //$this->form_validation->set_rules('password', 'Password', 'trim|required');
            $this->form_validation->set_rules('phone_number', 'Phone Number', 'trim|phone|min_length[8]|max_length[13]');

            $error = array();
            if ($this->form_validation->run() === False) {
                $error = $this->form_validation->error_array();
                $this->response(["error" => $error], REST_Controller::HTTP_BAD_REQUEST);
            }

            if ($this->doctor->userExist($postData['email'], $postData['phone_number'])) {
                $return['success'] 		= false;
                $return['message'] 		= "User already exist.";
                $return['error'] 		= '';
                $return['data'] 		= '';
                $this->response($return, REST_Controller::HTTP_CONFLICT);
            } else {

                $this->load->helper('password');
                $password = generatePassword();
                $this->load->library('elasticMail');
                $mail = new ElasticMail();
                $mailResponse = $mail->SendEmail3($postData['email'], "MyMd Registration", "", "MyMd", "Your temporary password is " . $password);
                $postData['password'] = $password;

                $userCreated = 0;
                
               // $mailResponse= json_decode($mailResponse);
                if ($mailResponse) 
                {
                    $postData['username'] = $postData['email'];
                    $postData['user_type'] = 2;
                    $postData['created_date'] = date("Y:m:d H:i:s");
                    $postData['account_enabled'] = 1;
                    $userCreated = $this->doctor->add($postData);
                }

                if ($mailResponse && $userCreated) {
                    $return['success'] 		= true;
                    $return['message'] 		= "Signup successfully.";
                    $return['error'] 		= '';
                    $return['data'] 		= '';
                    $this->response($return, REST_Controller::HTTP_CREATED);
                } else {
                    $return['success'] 		= false;
                    $return['message'] 		= "Something went wrong";
                    $return['error'] 		= '';
                    $return['data'] 		= '';
                    $this->response($return, REST_Controller::HTTP_INTERNAL_SERVER_ERROR);
                }
            }
        } else {
            $return['success'] 		= false;
            $return['message'] 		= "Please fill required field";
            $return['error'] 		= '';
            $return['data'] 		= '';
            $this->response($return, REST_Controller::HTTP_BAD_REQUEST);
        }
    }

    public function validate_post() {
        $postData = json_decode(file_get_contents('php://input'), true);
        $res = new blankClass();
        if (isset($postData['email']) && isset($postData['password']) && isset($postData['device']) && isset($postData['fcm_key'])) {
            $postData = $this->security->xss_clean($postData);
            $this->form_validation->set_data($postData);

            $this->form_validation->set_rules('email', 'Email', 'trim|required|valid_email');
            $this->form_validation->set_rules('password', 'Password', 'trim|required');

            $error = array();
            if ($this->form_validation->run() === False) {
                $error = $this->form_validation->error_array();
                $this->response(["error" => $error], REST_Controller::HTTP_BAD_REQUEST);
            }

            $result = $this->doctor->validate($postData['email'], $postData['password']);
            if ($result) {

                $this->db->where('id', $result->user_id);
                $this->db->update('user', array('logged_in' => 1, 'device' => $postData['device'], 'fcm_key' => $postData['fcm_key']));
                
                $this->db->where('id', $result->id);
                $this->db->update('doctor', array('device' => $postData['device'],'fcm_key' => $postData['fcm_key']));
                
                
                unset($result->user_id);
                $this->response(['data' => $result], REST_Controller::HTTP_ACCEPTED);
            } else {
                $return['success'] 		= false;
                $return['message'] 		= "Invalid login details";
                $return['error'] 		= '';
                $return['data'] 		= '';
                $this->response($return, REST_Controller::HTTP_UNAUTHORIZED);
            }
        } else {
            $return['success'] 		= false;
            $return['message'] 		= "All field required";
            $return['error'] 		= '';
            $return['data'] 		= '';
            $this->response($return, REST_Controller::HTTP_BAD_REQUEST);
        }
    }

    public function forget_password_post() {
        $postData = json_decode(file_get_contents('php://input'), true);
        $res = new blankClass();
        if (isset($postData['email'])) {
            $postData = $this->security->xss_clean($postData);
            $this->form_validation->set_data($postData);

            $this->form_validation->set_rules('email', 'Email', 'trim|required|valid_email');
            
            $error = array();

            if ($this->form_validation->run() === False) {
                $error = $this->form_validation->error_array();
                $this->response(["error" => $error], REST_Controller::HTTP_BAD_REQUEST);
            }

            $email = null;
            $mobile = null;
            if (isset($postData['email'])) {
                $email = $postData['email'];
            }

            $userExist = $this->doctor->userExist($email);
            if ($userExist) {
                $this->load->helper('password');
                $password = generatePassword();
                $this->load->library('elasticMail');
                $mail = new ElasticMail();
                $response = $mail->SendEmail3($postData['email'], "New Password", "", "MyMd", "Your new password is " . $password);
                $result = 0;
                
               // $response= json_decode($response);
               // if ($response && $response->success===true) 
                if ($response) 
                {
                    
                    $result = $this->doctor->resetPassword($userExist, $password);
                    if ($result) 
                    {
                        $return['success'] 		= true;
                        $return['message'] 		= "Password reset successfully.Please check your email.";
                        $return['error'] 		= '';
                        $return['data'] 		= '';
                        $this->response($return, REST_Controller::HTTP_RESET_CONTENT);
                    } 
                    else
                    {
                        $return['success'] 		= false;
                        $return['message'] 		= "Something went wrong.";
                        $return['error'] 		= '';
                        $return['data'] 		= '';
                        $this->response($return, REST_Controller::HTTP_INTERNAL_SERVER_ERROR);
                    }
                }
                else 
                {
                        $return['success'] 		= false;
                        $return['message'] 		= "Something went wrong.";
                        $return['error'] 		= '';
                        $return['data'] 		= '';
                        $this->response($return, REST_Controller::HTTP_INTERNAL_SERVER_ERROR);
                }
            } else {
                $return['success'] 		= false;
                $return['message'] 		= "User email not exist.";
                $return['error'] 		= '';
                $return['data'] 		= '';
                $this->response($return, REST_Controller::HTTP_UNAUTHORIZED);
            }
        } else {
            $return['success'] 		= false;
            $return['message'] 		= "Email is required.";
            $return['error'] 		= '';
            $return['data'] 		= '';
            $this->response($return, REST_Controller::HTTP_BAD_REQUEST);
        }
    }

}
