<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Admin extends CI_Controller {

    public function __construct() {
        parent::__construct();
		$this->load->library('session');
		
        if ($this->session->userdata('is_logged_in') != true || $this->session->userdata('user_role') != 'Admin') {
            redirect(base_url().'admin/login');
        }
        $this->load->model('user_model','user');
    }

    public function index() {

        $page = "Admin";
        $data['title'] = ucfirst($page);
        $userdata = $this->session->userdata('user_data');
		//print_r($userdata);
		//die;
        $data['user_name'] = $userdata->UserName;
        $data['menu'] = "dashboard";
        $this->load->view('index', $data);
    }

    //Dashboard
    public function dashboard() {
        $this->load->view('dashboard');
    }

    public function total_doctor()
    {
        $data = $this->user->total_doctor();
        echo $data;
    }
    
    public function total_patient()
    {
        $data = $this->user->total_patient();
        echo $data;
    }
	
	public function total_package()
    {
        $data = $this->user->total_package();
        echo $data;
    }
	
	public function get_doctor()
    {
        $data = $this->user->get_doctor();		
        echo json_encode($data);
    }

	public function get_patient()
    {
        $data = $this->user->get_patient();		
        echo json_encode($data);
    }
		    
   
    //!Dashboard
    
    public function profile() {
        //$userdata = $this->session->userdata('userdata');
        //$data['user_data'] = $this->user->getUserDetails($userdata->UserID);
       // $data['user_role'] = $this->user->getUserRoles();
        $this->load->view('profile');
    }

    public function updateProfile()
    {
        $photo = $this->do_upload_image();
        //print_r($photo);die;
        $formData = $_POST;
        
        if($photo)
        {
           $formData['UserPhoto'] = $photo['file_name'] ;
        }
        $userdata = $this->session->userdata('user_data');
        $this->db->where('UserID',$userdata->UserID);
        $result = $this->db->update('tbluser',$formData);
        if($result)
        {
            echo "Profile updated";
        }
        else 
        {
            echo "Some error happen.";
        }
    }
    
    public function getUserData()
    {
        $userData = $this->session->userdata('user_data');
        $data = $this->user->getUserDetails($userData->UserID);
        echo json_encode($data);
        
    }
    
    public function Config()
    {
        $this->load->view('setting');
    }
    
    
    public function getSettings()
    {
        $data = $this->user->getSettings();
        echo json_encode($data);
    }
    
    public function updateSettings()
    {
        $data = json_decode( file_get_contents('php://input'),true);
        $response = array("success"=>'',"error"=>'',"title"=>'',"message"=>'');
        
        if($this->user->updateSettings($data))
        {
            $response['success']=1;
            $response['title']= "Success";
            $response['message']= "Settings Updated successfully.";
        }
        else
        {
            $response['error']=1;
            $response['title']= "Error";
            $response['message']= "Some error happen!";
        }
        echo json_encode($response);
    }
    
    //Taxonomy
    public function Taxonomy()
    {
        $this->load->view('taxonomy');
    }

    public function TaxonomyList()
    {
        $this->db->from('taxonomy m');
        
        if(isset($_GET['search']))
        {
            if($_GET['search'] != 'undefined')
            {
                $s = $_GET['search'];
                $this->db->where("m.name like '$s%' ");
            }
        } 
        
        if(isset($_GET['limit']))
        {
            if($_GET['limit'] !='undefined')
                $this->db->limit($_GET['limit'],$_GET['page']*$_GET['limit']);
        }
        
        
        $this->db->order_by("name","ASC");
        
        $query = $this->db->get();
        $result = array();
        if($query->num_rows() > 0)
        {
            $result = $query->result();
        }
        
        echo json_encode($result);
    }
    
    public function addTaxonomy()
    {
        $data = json_decode( file_get_contents('php://input'),true);
        $response = array("success"=>'',"error"=>'',"title"=>'',"message"=>'');
        if($this->user->TaxonomyExist($data))
        {
            $response['error']=1;
            $response['title']= "Error";
            $response['message']= "Taxonomy Alredy Exist.";
            
        }
        else
        {
            $this->user->addTaxonomy($data);
            $response['success']=1;
            $response['title']= "Success";
            $response['message']= "$data[name] Added successfully.";
            
        }
        echo json_encode($response);
    }

    public function getTaxonomy($id)
    {
        $data = $this->user->getTaxonomy($id);
        echo json_encode($data);
    }  
    
    public function updateTaxonomy()
    {
        $data = json_decode( file_get_contents('php://input'),true);
        $response = array("success"=>'',"error"=>'',"title"=>'',"message"=>'');
        
        if($this->user->updateTaxonomy($data))
        {
            $response['success']=1;
            $response['title']= "Success";
            $response['message']= "Updated successfully.";
        }
        else
        {
            $response['error']=1;
            $response['title']= "Error";
            $response['message']= "Some error happen!";
        }
        echo json_encode($response);
    }
    
    //!Taxonomy
    
    //State
    public function state()
    {
        $this->load->view('state');
    }

    public function StateList()
    {
        $this->db->from('state m');
        
        if(isset($_GET['search']))
        {
            if($_GET['search'] != 'undefined')
            {
                $s = $_GET['search'];
                $this->db->where("m.name like '$s%' ");
            }
        } 
        
        if(isset($_GET['limit']))
        {
            if($_GET['limit'] !='undefined')
                $this->db->limit($_GET['limit'],$_GET['page']*$_GET['limit']);
        }
        
        
        $this->db->order_by("name","ASC");
        
        $query = $this->db->get();
        $result = array();
        if($query->num_rows() > 0)
        {
            $result = $query->result();
        }
        
        echo json_encode($result);
    }
    
    public function addState()
    {
        $data = json_decode( file_get_contents('php://input'),true);
        $response = array("success"=>'',"error"=>'',"title"=>'',"message"=>'');
        if($this->user->StateExist($data))
        {
            $response['error']=1;
            $response['title']= "Error";
            $response['message']= "State Alredy Exist.";
            
        }
        else
        {
            $this->user->addState($data);
            $response['success']=1;
            $response['title']= "Success";
            $response['message']= "$data[name] Added successfully.";
            
        }
        echo json_encode($response);
    }

    public function getState($id)
    {
        $id = str_replace('_', '-', $id);
        $data = $this->user->getState($id);
        echo json_encode($data);
    }  
    
    public function updateState()
    {
        $data = json_decode( file_get_contents('php://input'),true);
        $response = array("success"=>'',"error"=>'',"title"=>'',"message"=>'');
        
        if($this->user->updateState($data))
        {
            $response['success']=1;
            $response['title']= "Success";
            $response['message']= "Updated successfully.";
        }
        else
        {
            $response['error']=1;
            $response['title']= "Error";
            $response['message']= "Some error happen!";
        }
        echo json_encode($response);
    }
    
    //!State
    
    //ZipCode
    public function zipcode()
    {
        $this->load->view('zipcode'); 
    }

    public function ZipCodeList()
    {
        $this->db->from('us_zip_code m');
        
        if(isset($_GET['search']))
        {
            if($_GET['search'] != 'undefined')
            {
                $s = $_GET['search'];
                $this->db->where("m.zip like '$s%' ");
            }
        } 
        
        if(isset($_GET['limit']))
        {
            if($_GET['limit'] !='undefined')
                $this->db->limit($_GET['limit'],$_GET['page']*$_GET['limit']);
        }
        
        
        $this->db->order_by("zip","ASC");
        
        $query = $this->db->get();
        $result = array();
        if($query->num_rows() > 0)
        {
            $result = $query->result();
        }
        
        echo json_encode($result);
    }
    
    public function addZipCode()
    {
        $data = json_decode( file_get_contents('php://input'),true);
        $response = array("success"=>'',"error"=>'',"title"=>'',"message"=>'');
        if($this->user->ZipCodeExist($data))
        {
            $response['error']=1;
            $response['title']= "Error";
            $response['message']= "Zip Code Alredy Exist.";
            
        }
        else
        {
            $this->user->addZipCode($data);
            $response['success']=1;
            $response['title']= "Success";
            $response['message']= "$data[zip] Added successfully.";
            
        }
        echo json_encode($response);
    }

    public function getZipCode($zip)
    {
        $data = $this->user->getZipCode($zip);
        echo json_encode($data);
    }  
    
    public function updateZipCode()
    {
        $data = json_decode( file_get_contents('php://input'),true);
        $response = array("success"=>'',"error"=>'',"title"=>'',"message"=>'');
        
        if($this->user->updateZipCode($data))
        {
            $response['success']=1;
            $response['title']= "Success";
            $response['message']= "Updated successfuly.";
        }
        else
        {
            $response['error']=1;
            $response['title']= "Error";
            $response['message']= "Some error happen!";
        }
        echo json_encode($response);
    }
    
    //!ZipCode
    
    //Patient
    public function patient()
    {
        $this->load->view('patient'); 
    }

    public function patientDetail($id)
    {
        $id = str_replace('_', '-', $id);
        $data['PatientID'] = $id;
        $this->load->view('patient-detail',$data); 
    }
    
    public function FamilyList($id)
    {
        $id = str_replace('_', '-', $id);
        $data = $this->user->getFamilyList($id);
        if($data===false){
            $data=[];
        }
        echo json_encode($data);
    }
    
    public function addFamily()
    {
        $data = json_decode( file_get_contents('php://input'),true);
        $response = array("success"=>'',"error"=>'',"title"=>'',"message"=>'');
        //print_r($data);die;
        if($this->user->addFamily($data))
        {
            $response['success']=1;
            $response['title']= "Success";
            $response['message']= "Added successfully.";
        }
        else
        {
            $response['error']=1;
            $response['title']= "Error";
            $response['message']= "Some error happen!";
        }
        echo json_encode($response);
    }
    
    public function updateFamily()
    {
        $data = json_decode( file_get_contents('php://input'),true);
        $response = array("success"=>'',"error"=>'',"title"=>'',"message"=>'');
        //print_r($data);die;
        if($this->user->updateFamily($data))
        {
            $response['success']=1;
            $response['title']= "Success";
            $response['message']= "Updated successfully.";
        }
        else
        {
            $response['error']=1;
            $response['title']= "Error";
            $response['message']= "Some error happen!";
        }
        echo json_encode($response);
    }
    
    public function PatientList()
    {
		$this->db->select("m.*,u.email");
        $this->db->from('patient m');
        
        if(isset($_GET['search']))
        {
            if($_GET['search'] != 'undefined')
            {
                $s = $_GET['search'];
                $this->db->where("m.first_name like '$s%' OR  m.last_name like '$s%' OR m.phone_number like '%$s%' ");
            }
        } 
        
        if(isset($_GET['limit']))
        {
            if($_GET['limit'] !='undefined')
                $this->db->limit($_GET['limit'],$_GET['page']*$_GET['limit']);
        }
        
        $this->db->join('user u','m.user_id = u.id','LEFT');
        //$this->db->order_by("id","desc");
        
        $query = $this->db->get();
				
        $result = array();
        if($query->num_rows() > 0)
        {
            $result = $query->result();
        }
        
        echo json_encode($result);
    }
    
    public function getPatient($id)
    {
        $id = str_replace('_', '-', $id);
        $data = $this->user->getPatient($id);
        echo json_encode($data);
    }  
    
    public function updatePatient()
    {
        $data = json_decode( file_get_contents('php://input'),true);
        $response = array("success"=>'',"error"=>'',"title"=>'',"message"=>'');
        
        if($this->user->updatePatient($data))
        {
            $response['success']=1;
            $response['title']= "Success";
            $response['message']= "Updated successfully.";
        }
        else
        {
            $response['error']=1;
            $response['title']= "Error";
            $response['message']= "Some error happen!";
        }
        echo json_encode($response);
    }
    
    //!Patient 
    
    //Doctor
    public function doctor()
    {
        $this->load->view('doctor'); 
    }

    public function doctorDetail($id)
    {
        $id = str_replace('_', '-', $id);
        $data['DoctorID'] = $id;
        $this->load->view('doctor-detail',$data); 
    }
    
    
    public function DoctorList()
    {
		$this->db->select("m.*,u.email");
        $this->db->from('doctor m');
        
        if(isset($_GET['search']))
        {
            if($_GET['search'] != 'undefined')
            {
                $s = $_GET['search'];
                $this->db->where("m.first_name like '$s%' OR  m.last_name like '$s%' OR m.practice_phone like '%$s%' ");
            }
        } 
        
        if(isset($_GET['limit']))
        {
            if($_GET['limit'] !='undefined')
                $this->db->limit($_GET['limit'],$_GET['page']*$_GET['limit']);
        }
        
        $this->db->join('user u','m.user_id = u.id','LEFT');
         $this->db->order_by("m.id","ASC");
        $query = $this->db->get();
        $result = array();
        if($query->num_rows() > 0)
        {
            $result = $query->result();
        }
        
        echo json_encode($result);
    }
    
    public function getDoctor($id)
    {
        $id = str_replace('_', '-', $id);
        $data = $this->user->getDoctor($id);
        echo json_encode($data);
    }
    
    public function getDoctorNPI($id)
    {
        $id = str_replace('_', '-', $id);
        $data = $this->user->getDoctorNPI($id);
        echo json_encode($data);
    }
    
    public function updateDoctor()
    {
        $data = json_decode( file_get_contents('php://input'),true);
        $response = array("success"=>'',"error"=>'',"title"=>'',"message"=>'');
        
        if($this->user->updateDoctor($data))
        {
            $response['success']=1;
            $response['title']= "Success";
            $response['message']= "Updated successfully.";
        }
        else
        {
            $response['error']=1;
            $response['title']= "Error";
            $response['message']= "Some error happen!";
        }
        echo json_encode($response);
    }    
    
    public function getDoctorLicence($id)
    {
        $id = str_replace('_', '-', $id);
        $data = $this->user->getDoctorLicence($id);
        echo json_encode($data);
    }
    
    public function updateDoctorLicence()
    {
        $data = json_decode( file_get_contents('php://input'),true);
        //print_r($data);die;
        $response = array("success"=>'',"error"=>'',"title"=>'',"message"=>'');
        
        if($this->user->updateDoctorLicence($data))
        {
            $response['success']=1;
            $response['title']= "Success";
            $response['message']= "Licence Updated successfully.";
        }
        else
        {
            $response['error']=1;
            $response['title']= "Error";
            $response['message']= "Some error happen!";
        }
        echo json_encode($response);
    }
    public function addDoctorLicence()
    {
        $data = json_decode( file_get_contents('php://input'),true);
        //print_r($data);die;
        $response = array("success"=>'',"error"=>'',"title"=>'',"message"=>'');
        
        if($this->user->addDoctorLicence($data))
        {
            $response['success']=1;
            $response['title']= "Success";
            $response['message']= "Licence Added successfully.";
        }
        else
        {
            $response['error']=1;
            $response['title']= "Error";
            $response['message']= "Some error happen!";
        }
        echo json_encode($response);
    }
    
    public function updatePassword()
    {
        $data = json_decode( file_get_contents('php://input'),true);
        $response = array("success"=>'',"error"=>'',"title"=>'',"message"=>'');
        
        $data = $this->security->xss_clean($data);
        $this->form_validation->set_data($data);
        $this->form_validation->set_rules('oldpassword', 'Old Password', 'trim|required');
        $this->form_validation->set_rules('newpassword', 'New Password', 'trim|required');
        $this->form_validation->set_rules('confirmpassword', 'Confirm Password', 'trim|required|matches[newpassword]');
        
        $error = array();
        if ($this->form_validation->run() === False) {
            $error = validation_errors();
            $response['error']=1;
            $response['title']= "Error";
            $response['message']= $error;
        }
        else
        {
            $userData = $this->session->userdata('user_data');
            if($this->user->matchPassword($userData->id, md5($data['oldpassword'])))
            {
                if($this->user->updatePassword($userData->id,md5($data['newpassword'])))
                {
                    $response['success']=1;
                    $response['title']= "Success";
                    $response['message']= "Password updated successfully.";
                }
                else
                {
                    $response['error']=1;
                    $response['title']= "Error";
                    $response['message']= "Some error happen!";
                }
            }
            else
            {
                $response['error']=1;
                $response['title']= "Error";
                $response['message']= "Old password did not match.";
            }
        }
        echo json_encode($response);
    } 
    
    public function getDoctorTaxonomy($id)
    {
        $id = str_replace('_', '-', $id);
        $data = $this->user->getDoctorTaxonomy($id);
        echo json_encode($data);
    }
    
    public function deleteDoctorTaxonomy()
    {
        $data = json_decode( file_get_contents('php://input'),true);
        
        $response = array("success"=>'',"error"=>'',"title"=>'',"message"=>'');
        
                   
        if($this->user->deleteDoctorTaxonomy($data))
        {
            $response['success']=1;
            $response['title']= "Success";
            $response['message']= "Taxonomy deleted successfully.";
        }
        else
        {
            $response['error']=1;
            $response['title']= "Error";
            $response['message']= "Some error happen!";
        }
        
        echo json_encode($response);
    }
    
    public function addDoctorTaxonomy()
    {
        $data = json_decode( file_get_contents('php://input'),true);
        //print_r($data);die;
        $response = array("success"=>'',"error"=>'',"title"=>'',"message"=>'');
        
        $this->db->where($data);
        $query = $this->db->get('doctor_taxonomy');
        
        if($query->num_rows() > 0)
        {
            $response['error']=1;
            $response['title']= "Error";
            $response['message']= "Already exist!";
        }
        else
        {            
            if($this->user->addDoctorTaxonomy($data))
            {
                $response['success']=1;
                $response['title']= "Success";
                $response['message']= "Taxonomy added successfully.";
            }
            else
            {
                $response['error']=1;
                $response['title']= "Error";
                $response['message']= "Some error happen!";
            }
        }
        echo json_encode($response);
    }
    
    public function getNPI($npi_number)
    {
        if(isset($npi_number))
        {
            $result = $this->checkNPI($npi_number);
            $response = array("success"=>'',"error"=>'',"title"=>'',"message"=>'');
            if(isset($result->results))
            {
                if($result->result_count == 1)
                {
                    if($result->results[0]->enumeration_type == 'NPI-1')
                    {
                        $res = $result->results[0];
                        $response['success']=1;
                        $response['title']= "Success";
                        $response['message']= "NPI details found, please verify.";
                        $response['NPI']= $res;                     
                    }
                    else
                    {
                        $response['error']=1;
                        $response['title']= "Error";
                        $response['message']= "You can not add NPI-2.";
                    }
                }
                else
                {
                    $response['error']=1;
                    $response['title']= "Error";
                    $response['message']= "No data found.";
                }
            }
            else
            {
                $response['error']=1;
                $response['title']= "Error";
                $response['message']= "NPI Number is wrong, Please check your NPI number.";
            }
        }
        
        echo json_encode($response);
    }
    
    public function updateNPI($DoctorID)
    {
        $DoctorID = str_replace('_', '-', $DoctorID);
        $data = json_decode( file_get_contents('php://input'));
        
        $response = array("success"=>'',"error"=>'',"title"=>'',"message"=>'');
        
        $userData = $this->session->userdata('user_data');
        
        
        if($this->user->updateNPI($DoctorID,$data))
        {
            $response['success']=1;
            $response['title']= "Success";
            $response['message']= "NPI Updated successfully.";
        }
        else
        {
            $response['error']=1;
            $response['title']= "Error";
            $response['message']= "Some error happen!";
        }
        echo json_encode($response);
    }
    
    private function checkNPI($npi_number)
    {
        $url = "https://npiregistry.cms.hhs.gov/api/?number=".$npi_number.'&version=2.1';
        $result = file_get_contents($url);
        $data = json_decode($result);
        return $data;
    }
    
    //!Doctor
    
    
    //Package
    public function Package()
    {
        $this->load->view('package');
    }

    public function PackageList()
    {
        $this->db->from('consult_package m');
        
        if(isset($_GET['search']))
        {
            if($_GET['search'] != 'undefined')
            {
                $s = $_GET['search'];
                $this->db->where("m.package_name like '$s%' ");
            }
        } 
        
        if(isset($_GET['limit']))
        {
            if($_GET['limit'] !='undefined')
                $this->db->limit($_GET['limit'],$_GET['page']*$_GET['limit']);
        }
        
        
        $this->db->order_by("package_name","ASC");
        
        $query = $this->db->get();
        $result = array();
        if($query->num_rows() > 0)
        {
            $result = $query->result();
        }
        
        echo json_encode($result);
    }
    
    public function addPackage()
    {
        $data = json_decode( file_get_contents('php://input'),true);
        $_POST = $data;
        $response = array("success"=>'',"error"=>'',"title"=>'',"message"=>'');
        
        $this->form_validation->set_rules('package_name', 'Package Name', 'trim|required');
        $this->form_validation->set_rules('validity_period', 'Validity Period', 'trim|required|numeric');
        $this->form_validation->set_rules('validity_period_unit', 'Validity Period Unit', 'trim|required|numeric');
        $this->form_validation->set_rules('no_of_consults', 'Number of Consults', 'trim|required|numeric');
        $this->form_validation->set_rules('amount', 'Amount', 'trim|required|decimal');
        
        
        if ($this->form_validation->run() == FALSE)
        {
                $response['error']=1;
                $response['title']= "Error";
                $response['message']= validation_errors(); 
        }
        else
        {
            if($this->user->PackageExist($data))
            {
                $response['error']=1;
                $response['title']= "Error";
                $response['message']= "Package Alredy Exist.";

            }
            else
            {
                $this->user->addPackage($data);
                $response['success']=1;
                $response['title']= "Success";
                $response['message']= "$data[package_name] Added successfully.";

            }
        }
        
        echo json_encode($response);
    }

    public function getPackage($id)
    {
        $data = $this->user->getPackage($id);
        echo json_encode($data);
    }  
    
    public function updatePackage()
    {
        $data = json_decode( file_get_contents('php://input'),true);
        $_POST = $data;
        $response = array("success"=>'',"error"=>'',"title"=>'',"message"=>'');
        
        $this->form_validation->set_rules('package_name', 'Package Name', 'trim|required');
        $this->form_validation->set_rules('validity_period', 'Validity Period', 'trim|required|numeric');
        $this->form_validation->set_rules('validity_period_unit', 'Validity Period Unit', 'trim|required|numeric');
        $this->form_validation->set_rules('no_of_consults', 'Number of Consults', 'trim|required|numeric');
        $this->form_validation->set_rules('amount', 'Amount', 'trim|required|numeric');
        
        
        if ($this->form_validation->run() == FALSE)
        {
                $response['error']=1;
                $response['title']= "Error";
                $response['message']= validation_errors(); 
        }
        else
        {
        
            if($this->user->updatePackage($data))
            {
                $response['success']=1;
                $response['title']= "Success";
                $response['message']= "Updated successfully.";
            }
            else
            {
                $response['error']=1;
                $response['title']= "Error";
                $response['message']= "Some error happen!";
            }
        }
        echo json_encode($response);
    }
    
    public function makeDefaultDoctor()
    {
        $data = json_decode( file_get_contents('php://input'),true);
        $response = array("success"=>'',"error"=>'',"title"=>'',"message"=>'');
        
        if($this->user->makeDefaultDoctor($data))
        {
            $response['success']=1;
            $response['title']= "Success";
            $response['message']= "Default successfully.";
        }
        else
        {
            $response['error']=1;
            $response['title']= "Error";
            $response['message']= "Some error happen!";
        }
        echo json_encode($response);
    }
   
}
